/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.query.engine.exception;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.qpid.server.query.engine.exception.QueryEngineException;
import org.apache.qpid.server.query.engine.parsing.ParseException;

public class QueryParsingException
extends QueryEngineException {
    private String message;
    private static final String INVALID_DATEPART_MARKER = " Was expecting one of: \"DAY\" ... \"HOUR\" ... \"MILLISECOND\" ... \"MINUTE\" ... \"MONTH\" ... \"SECOND\" ... \"WEEK\" ... \"YEAR\"";

    protected QueryParsingException() {
    }

    protected QueryParsingException(String message) {
        super(message);
    }

    public QueryParsingException(Throwable throwable) {
        this.initCause(throwable);
        if (throwable instanceof ParseException) {
            ParseException parseException = (ParseException)throwable;
            if ("select".equalsIgnoreCase(parseException.currentToken.image) && "<EOF>".equals(parseException.tokenImage[0])) {
                this.message = "Missing expression";
            }
            if ("from".equalsIgnoreCase(parseException.currentToken.image) && "<EOF>".equals(parseException.tokenImage[0])) {
                this.message = "Missing domain name";
            }
            String errorMessage = parseException.getMessage().replaceAll("\\s+", " ").trim();
            try {
                Matcher matcher;
                if (errorMessage.contains(INVALID_DATEPART_MARKER) && (matcher = Pattern.compile("(?<=[^\\s][\"|>]\\s\")(.*?)(?=\"\")").matcher(errorMessage)).find()) {
                    String datepart = matcher.group(0).trim();
                    this.message = "Datepart '" + datepart + "' not supported";
                }
            }
            catch (Exception e) {
                this.message = e.getMessage();
            }
            if (this.message == null) {
                this.message = errorMessage;
            }
        }
    }

    protected QueryParsingException(String message, Throwable throwable) {
        super(message, throwable);
    }

    public static QueryParsingException of(String message, Object ... args) {
        return new QueryParsingException(String.format(message, args));
    }

    @Override
    public String getMessage() {
        return this.message != null ? this.message : super.getMessage();
    }
}

