/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.bytebuffer;

import java.io.IOException;
import java.io.InputStream;
import org.apache.qpid.server.bytebuffer.QpidByteBuffer;

final class QpidByteBufferInputStream
extends InputStream {
    private final QpidByteBuffer _qpidByteBuffer;

    QpidByteBufferInputStream(QpidByteBuffer buffer) {
        this._qpidByteBuffer = buffer.duplicate();
    }

    @Override
    public int read() throws IOException {
        if (this._qpidByteBuffer.hasRemaining()) {
            return this._qpidByteBuffer.getUnsignedByte();
        }
        return -1;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (!this._qpidByteBuffer.hasRemaining()) {
            return -1;
        }
        int remaining = this._qpidByteBuffer.remaining();
        if (remaining < len) {
            len = remaining;
        }
        this._qpidByteBuffer.get(b, off, len);
        return len;
    }

    @Override
    public void mark(int readlimit) {
        this._qpidByteBuffer.mark();
    }

    @Override
    public void reset() throws IOException {
        this._qpidByteBuffer.reset();
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public long skip(long n) throws IOException {
        this._qpidByteBuffer.position(this._qpidByteBuffer.position() + (int)n);
        return n;
    }

    @Override
    public int available() throws IOException {
        return this._qpidByteBuffer.remaining();
    }

    @Override
    public void close() {
        this._qpidByteBuffer.dispose();
    }
}

