/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.util;

import java.lang.reflect.Array;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class MapValueConverter {
    public static String getStringAttribute(String name, Map<String, Object> attributes, String defaultVal) {
        Object value = attributes.get(name);
        return MapValueConverter.toString(value, defaultVal);
    }

    public static String toString(Object value) {
        return MapValueConverter.toString(value, null);
    }

    public static String toString(Object value, String defaultVal) {
        if (value == null) {
            return defaultVal;
        }
        if (value instanceof String) {
            return (String)value;
        }
        return String.valueOf(value);
    }

    public static <E extends Enum> E getEnumAttribute(Class<E> clazz, String name, Map<String, Object> attributes, E defaultVal) {
        Object obj = attributes.get(name);
        if (obj == null) {
            return defaultVal;
        }
        if (clazz.isInstance(obj)) {
            return (E)((Enum)obj);
        }
        if (obj instanceof String) {
            return Enum.valueOf(clazz, (String)obj);
        }
        throw new IllegalArgumentException("Value for attribute " + name + " is not of required type " + clazz.getSimpleName());
    }

    public static <T extends Enum<T>> T toEnum(String name, Object rawValue, Class<T> enumType) {
        if (enumType.isInstance(rawValue)) {
            return (T)((Enum)rawValue);
        }
        if (rawValue instanceof String) {
            String stringValue = (String)rawValue;
            return "null".equals(stringValue) ? null : (T)Enum.valueOf(enumType, stringValue);
        }
        if (rawValue == null) {
            return null;
        }
        throw new IllegalArgumentException("Value for attribute " + name + " is not of required type " + enumType.getSimpleName());
    }

    public static Boolean getBooleanAttribute(String name, Map<String, Object> attributes, Boolean defaultValue) {
        Object obj = attributes.get(name);
        return MapValueConverter.toBoolean(name, obj, defaultValue);
    }

    public static Boolean toBoolean(String name, Object obj) {
        return MapValueConverter.toBoolean(name, obj, null);
    }

    public static Boolean toBoolean(String name, Object obj, Boolean defaultValue) {
        if (obj == null) {
            return defaultValue;
        }
        if (obj instanceof Boolean) {
            return (Boolean)obj;
        }
        if (obj instanceof String) {
            return Boolean.parseBoolean((String)obj);
        }
        throw new IllegalArgumentException("Value for attribute " + name + " is not of required type Boolean");
    }

    public static Integer getIntegerAttribute(String name, Map<String, Object> attributes, Integer defaultValue) {
        Object obj = attributes.get(name);
        return MapValueConverter.toInteger(name, obj, defaultValue);
    }

    public static Integer toInteger(String name, Object obj) {
        return MapValueConverter.toInteger(name, obj, null);
    }

    public static Integer toInteger(String name, Object obj, Integer defaultValue) {
        if (obj == null) {
            return defaultValue;
        }
        if (obj instanceof Number) {
            return ((Number)obj).intValue();
        }
        if (obj instanceof String) {
            return Integer.valueOf((String)obj);
        }
        throw new IllegalArgumentException("Value for attribute " + name + " is not of required type Integer");
    }

    public static Long toLong(String name, Object obj) {
        return MapValueConverter.toLong(name, obj, null);
    }

    public static Long toLong(String name, Object obj, Long defaultValue) {
        if (obj == null) {
            return defaultValue;
        }
        if (obj instanceof Number) {
            return ((Number)obj).longValue();
        }
        if (obj instanceof String) {
            return Long.valueOf((String)obj);
        }
        throw new IllegalArgumentException("Value for attribute " + name + " is not of required type Long");
    }

    public static <T extends Enum<T>> Set<T> getEnumSetAttribute(String name, Map<String, Object> attributes, Class<T> clazz) {
        Object obj = attributes.get(name);
        if (obj == null) {
            return null;
        }
        return MapValueConverter.toSet(obj, clazz, name);
    }

    public static <T> Set<T> toSet(Object rawValue, Class<T> setItemClass, String attributeName) {
        if (rawValue == null) {
            return null;
        }
        HashSet<T> set = new HashSet<T>();
        if (rawValue instanceof Iterable) {
            Iterable iterable = (Iterable)rawValue;
            for (Object object : iterable) {
                T converted = MapValueConverter.convert(object, setItemClass, attributeName);
                set.add(converted);
            }
        } else if (rawValue.getClass().isArray()) {
            int length = Array.getLength(rawValue);
            for (int i = 0; i < length; ++i) {
                Object arrayElement = Array.get(rawValue, i);
                T converted = MapValueConverter.convert(arrayElement, setItemClass, attributeName);
                set.add(converted);
            }
        } else {
            throw new IllegalArgumentException("Cannot convert '" + String.valueOf(rawValue.getClass()) + "' into Set<" + setItemClass.getSimpleName() + "> for attribute " + attributeName);
        }
        return set;
    }

    public static <T> T convert(Object rawValue, Class<T> classObject, String attributeName) {
        Object value;
        if (classObject == Long.class || classObject == Long.TYPE) {
            value = MapValueConverter.toLong(attributeName, rawValue);
        } else if (classObject == Integer.class || classObject == Integer.TYPE) {
            value = MapValueConverter.toInteger(attributeName, rawValue);
        } else if (classObject == Boolean.class || classObject == Boolean.TYPE) {
            value = MapValueConverter.toBoolean(attributeName, rawValue);
        } else if (classObject == String.class) {
            value = MapValueConverter.toString(rawValue);
        } else if (Enum.class.isAssignableFrom(classObject)) {
            value = MapValueConverter.toEnum(attributeName, rawValue, classObject);
        } else if (classObject == Object.class) {
            value = rawValue;
        } else {
            throw new IllegalArgumentException("Cannot convert '" + String.valueOf(rawValue) + "' of type '" + String.valueOf(rawValue.getClass()) + "' into type " + String.valueOf(classObject) + " for attribute " + attributeName);
        }
        return (T)value;
    }
}

