/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.model;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.apache.qpid.server.model.AttributeValueConverter;
import org.apache.qpid.server.model.ConfiguredObject;
import org.apache.qpid.server.model.ConfiguredObjectInjectedAttributeOrStatistic;
import org.apache.qpid.server.model.ConfiguredObjectStatistic;
import org.apache.qpid.server.model.InjectedAttributeStatisticOrOperation;
import org.apache.qpid.server.model.StatisticType;
import org.apache.qpid.server.model.StatisticUnit;
import org.apache.qpid.server.util.ServerScopedRuntimeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ConfiguredObjectInjectedStatistic<C extends ConfiguredObject, T extends Number>
extends ConfiguredObjectInjectedAttributeOrStatistic<C, T>
implements ConfiguredObjectStatistic<C, T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfiguredObjectInjectedStatistic.class);
    private final String _description;
    private final Method _method;
    private final StatisticUnit _units;
    private final StatisticType _type;
    private final String _label;
    private final Object[] _staticParams;
    private final String _metricName;
    private final boolean _metricDisabled;

    public ConfiguredObjectInjectedStatistic(String name, Method method, Object[] staticParams, String description, InjectedAttributeStatisticOrOperation.TypeValidator typeValidator, StatisticUnit units, StatisticType type, String label, String metricName, boolean metricDisabled) {
        super(name, AttributeValueConverter.getTypeFromMethod(method), method.getGenericReturnType(), typeValidator);
        this._units = units;
        this._type = type;
        this._label = label;
        this._staticParams = staticParams == null ? new Object[]{} : staticParams;
        this._metricName = metricName;
        this._metricDisabled = metricDisabled;
        if (!(method.getParameterTypes().length == 1 + this._staticParams.length && ConfiguredObject.class.isAssignableFrom(method.getParameterTypes()[0]) && Modifier.isStatic(method.getModifiers()) && Number.class.isAssignableFrom(AttributeValueConverter.getTypeFromMethod(method)))) {
            throw new IllegalArgumentException("Injected statistic method must be static, have first argument which inherits from ConfiguredObject, and return a Number");
        }
        Class<?>[] methodParamTypes = method.getParameterTypes();
        for (int i = 0; i < this._staticParams.length; ++i) {
            if (methodParamTypes[i + 1].isPrimitive() && this._staticParams[i] == null) {
                throw new IllegalArgumentException("Static parameter has null value, but the " + methodParamTypes[i + 1].getSimpleName() + " type is a primitive");
            }
            if (AttributeValueConverter.convertPrimitiveToBoxed(methodParamTypes[i + 1]).isAssignableFrom(this._staticParams[i].getClass())) continue;
            throw new IllegalArgumentException("Static parameter cannot be assigned value as it is of incompatible type");
        }
        this._method = method;
        method.setAccessible(true);
        this._description = description;
    }

    @Override
    public String getDescription() {
        return this._description;
    }

    @Override
    public StatisticUnit getUnits() {
        return this._units;
    }

    @Override
    public StatisticType getStatisticType() {
        return this._type;
    }

    @Override
    public String getLabel() {
        return this._label;
    }

    @Override
    public T getValue(C configuredObject) {
        try {
            Object[] params = new Object[1 + this._staticParams.length];
            params[0] = configuredObject;
            for (int i = 0; i < this._staticParams.length; ++i) {
                params[i + 1] = this._staticParams[i];
            }
            return (T)((Number)this._method.invoke(null, params));
        }
        catch (IllegalAccessException e) {
            throw new ServerScopedRuntimeException("Unable to get value for '" + this.getName() + "' from configured object of category " + configuredObject.getCategoryClass().getSimpleName(), e);
        }
        catch (InvocationTargetException e) {
            Throwable targetException = e.getTargetException();
            if (targetException instanceof RuntimeException) {
                throw (RuntimeException)targetException;
            }
            if (targetException instanceof Error) {
                throw (Error)targetException;
            }
            throw new ServerScopedRuntimeException("Unable to get value for '" + this.getName() + "' from configured object of category " + configuredObject.getCategoryClass().getSimpleName(), e);
        }
    }

    @Override
    public String getMetricName() {
        return this._metricName;
    }

    @Override
    public boolean isMetricDisabled() {
        return this._metricDisabled;
    }

    @Override
    public boolean isResettable() {
        return false;
    }
}

