/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.virtualhost.berkeleydb;

import com.sleepycat.je.Durability;
import java.util.Map;
import java.util.Set;
import org.apache.qpid.server.model.ConfiguredObject;
import org.apache.qpid.server.model.ManagedAttributeField;
import org.apache.qpid.server.model.ManagedObject;
import org.apache.qpid.server.model.ManagedObjectFactoryConstructor;
import org.apache.qpid.server.model.VirtualHostNode;
import org.apache.qpid.server.store.MessageStore;
import org.apache.qpid.server.store.berkeleydb.BDBConfigurationStore;
import org.apache.qpid.server.store.berkeleydb.replication.ReplicatedEnvironmentFacade;
import org.apache.qpid.server.virtualhost.AbstractVirtualHost;
import org.apache.qpid.server.virtualhost.berkeleydb.BDBHAVirtualHost;

@ManagedObject(category=false, type="BDB_HA")
public class BDBHAVirtualHostImpl
extends AbstractVirtualHost<BDBHAVirtualHostImpl>
implements BDBHAVirtualHost<BDBHAVirtualHostImpl> {
    public static final String VIRTUAL_HOST_TYPE = "BDB_HA";
    private final BDBConfigurationStore _configurationStore;
    @ManagedAttributeField
    private String _localTransactionSynchronizationPolicy;
    @ManagedAttributeField
    private String _remoteTransactionSynchronizationPolicy;
    @ManagedAttributeField
    private Long _storeUnderfullSize;
    @ManagedAttributeField
    private Long _storeOverfullSize;

    @ManagedObjectFactoryConstructor(conditionallyAvailable=true, condition="org.apache.qpid.server.JECheck#isAvailable()")
    public BDBHAVirtualHostImpl(Map<String, Object> attributes, VirtualHostNode<?> virtualHostNode) {
        super(attributes, virtualHostNode);
        this._configurationStore = (BDBConfigurationStore)virtualHostNode.getConfigurationStore();
    }

    protected MessageStore createMessageStore() {
        return this._configurationStore.getMessageStore();
    }

    @Override
    public String getLocalTransactionSynchronizationPolicy() {
        return this._localTransactionSynchronizationPolicy;
    }

    @Override
    public String getRemoteTransactionSynchronizationPolicy() {
        return this._remoteTransactionSynchronizationPolicy;
    }

    @Override
    public String getDurability() {
        ReplicatedEnvironmentFacade facade = this.getReplicatedEnvironmentFacade();
        if (facade != null) {
            return String.valueOf(facade.getMessageStoreDurability());
        }
        return null;
    }

    @Override
    public boolean isCoalescingSync() {
        return Durability.SyncPolicy.SYNC.name().equals(this._localTransactionSynchronizationPolicy);
    }

    public void onOpen() {
        ReplicatedEnvironmentFacade facade = this.getReplicatedEnvironmentFacade();
        if (facade != null) {
            facade.setMessageStoreDurability(Durability.SyncPolicy.valueOf((String)this.getLocalTransactionSynchronizationPolicy()), Durability.SyncPolicy.valueOf((String)this.getRemoteTransactionSynchronizationPolicy()), ReplicatedEnvironmentFacade.REPLICA_REPLICA_ACKNOWLEDGMENT_POLICY);
        }
        super.onOpen();
    }

    protected void validateChange(ConfiguredObject<?> proxyForValidation, Set<String> changedAttributes) {
        String policy;
        super.validateChange(proxyForValidation, changedAttributes);
        if (changedAttributes.contains("localTransactionSynchronizationPolicy")) {
            policy = ((BDBHAVirtualHost)proxyForValidation).getLocalTransactionSynchronizationPolicy();
            this.validateTransactionSynchronizationPolicy(policy);
        }
        if (changedAttributes.contains("remoteTransactionSynchronizationPolicy")) {
            policy = ((BDBHAVirtualHost)proxyForValidation).getRemoteTransactionSynchronizationPolicy();
            this.validateTransactionSynchronizationPolicy(policy);
        }
    }

    private void validateTransactionSynchronizationPolicy(String policy) {
        try {
            Durability.SyncPolicy.valueOf((String)policy);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Invalid transaction synchronization policy '" + policy + "'. " + e.getMessage());
        }
    }

    private ReplicatedEnvironmentFacade getReplicatedEnvironmentFacade() {
        return (ReplicatedEnvironmentFacade)this._configurationStore.getEnvironmentFacade();
    }

    @Override
    public Long getStoreUnderfullSize() {
        return this._storeUnderfullSize;
    }

    @Override
    public Long getStoreOverfullSize() {
        return this._storeOverfullSize;
    }

    public void onValidate() {
        super.onValidate();
        this.validateTransactionSynchronizationPolicy(this.getLocalTransactionSynchronizationPolicy());
        this.validateTransactionSynchronizationPolicy(this.getRemoteTransactionSynchronizationPolicy());
    }
}

