/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.query.engine.parsing.expression.comparison;

import java.util.List;
import java.util.stream.Collectors;
import org.apache.qpid.server.query.engine.evaluator.SelectEvaluator;
import org.apache.qpid.server.query.engine.parsing.expression.ExpressionNode;
import org.apache.qpid.server.query.engine.parsing.expression.comparison.AbstractComparisonExpression;
import org.apache.qpid.server.query.engine.parsing.expression.comparison.EqualExpression;
import org.apache.qpid.server.query.engine.parsing.expression.literal.ConstantExpression;
import org.apache.qpid.server.query.engine.parsing.query.SelectExpression;

public class InExpression<T, R>
extends AbstractComparisonExpression<T, Boolean> {
    public InExpression(List<ExpressionNode<T, ?>> children) {
        super(children);
        String firstAlias = this.getChild(0).getAlias();
        String aliases = children.subList(1, children.size()).stream().map(ExpressionNode::getAlias).collect(Collectors.joining(","));
        this._metadata.setAlias(firstAlias + " in (" + aliases + ")");
    }

    public InExpression(ExpressionNode<T, ?> left, SelectExpression<T, R> right) {
        super(left, right);
    }

    @Override
    public Boolean apply(T value) {
        ExpressionNode left = this.getChild(0);
        ExpressionNode right = this.getChild(1);
        if (right instanceof SelectExpression) {
            SelectExpression selectExpression = (SelectExpression)right;
            List items = (List)selectExpression.apply(new SelectEvaluator());
            return items.stream().anyMatch(item -> (Boolean)new EqualExpression(left, ConstantExpression.of(item)).apply(value));
        }
        List items = this.getChildren().subList(1, this.getChildren().size());
        return items.stream().map(item -> item.apply(value)).anyMatch(item -> (Boolean)new EqualExpression(ConstantExpression.of(left.apply(value)), ConstantExpression.of(item)).apply(item));
    }
}

