/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.util;

import io.kubernetes.client.openapi.ApiClient;
import io.kubernetes.client.openapi.ApiException;
import io.kubernetes.client.openapi.models.V1CertificateSigningRequest;
import io.kubernetes.client.util.CSRUtils;
import io.kubernetes.client.util.FilePersister;
import io.kubernetes.client.util.KubeConfig;
import io.kubernetes.client.util.SSLUtils;
import io.kubernetes.client.util.credentials.AccessTokenAuthentication;
import io.kubernetes.client.util.credentials.Authentication;
import io.kubernetes.client.util.credentials.ClientCertificateAuthentication;
import io.kubernetes.client.util.credentials.KubeconfigAuthentication;
import io.kubernetes.client.util.credentials.TokenFileAuthentication;
import io.kubernetes.client.util.exception.CSRNotApprovedException;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.security.PrivateKey;
import java.time.Duration;
import java.util.Arrays;
import java.util.List;
import okhttp3.Protocol;
import org.apache.commons.compress.utils.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientBuilder {
    private static final Logger log = LoggerFactory.getLogger(ClientBuilder.class);
    private String basePath = "http://localhost:8080";
    private byte[] caCertBytes = null;
    private boolean verifyingSsl = true;
    private Authentication authentication;
    private String keyStorePassphrase;
    private List<Protocol> protocols = Arrays.asList(Protocol.HTTP_2, Protocol.HTTP_1_1);
    private Duration readTimeout = Duration.ZERO;
    private Duration pingInterval = Duration.ofMinutes(1L);

    public static ApiClient defaultClient() throws IOException {
        return ClientBuilder.standard().build();
    }

    public static ClientBuilder standard() throws IOException {
        return ClientBuilder.standard(true);
    }

    public static ClientBuilder standard(boolean persistConfig) throws IOException {
        File kubeConfig = ClientBuilder.findConfigFromEnv();
        ClientBuilder clientBuilderEnv = ClientBuilder.getClientBuilder(persistConfig, kubeConfig);
        if (clientBuilderEnv != null) {
            return clientBuilderEnv;
        }
        File config = ClientBuilder.findConfigInHomeDir();
        ClientBuilder clientBuilderHomeDir = ClientBuilder.getClientBuilder(persistConfig, config);
        if (clientBuilderHomeDir != null) {
            return clientBuilderHomeDir;
        }
        File clusterCa = new File("/var/run/secrets/kubernetes.io/serviceaccount/ca.crt");
        if (clusterCa.exists()) {
            return ClientBuilder.cluster();
        }
        return new ClientBuilder();
    }

    private static ClientBuilder getClientBuilder(boolean persistConfig, File kubeConfig) throws IOException {
        if (kubeConfig != null) {
            try (BufferedReader kubeConfigReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(kubeConfig), StandardCharsets.UTF_8.name()));){
                KubeConfig kc = KubeConfig.loadKubeConfig(kubeConfigReader);
                if (persistConfig) {
                    kc.setPersistConfig(new FilePersister(kubeConfig));
                }
                kc.setFile(kubeConfig);
                ClientBuilder clientBuilder = ClientBuilder.kubeconfig(kc);
                return clientBuilder;
            }
        }
        return null;
    }

    private static File findConfigFromEnv() {
        KubeConfigEnvParser kubeConfigEnvParser = new KubeConfigEnvParser();
        String kubeConfigPath = kubeConfigEnvParser.parseKubeConfigPath(System.getenv("KUBECONFIG"));
        if (kubeConfigPath == null) {
            return null;
        }
        File kubeConfig = new File(kubeConfigPath);
        if (kubeConfig.exists()) {
            return kubeConfig;
        }
        log.debug("Could not find file specified in $KUBECONFIG");
        return null;
    }

    private static File findHomeDir() {
        File config;
        String envHome = System.getenv("HOME");
        if (envHome != null && envHome.length() > 0 && (config = new File(envHome)).exists()) {
            return config;
        }
        if (System.getProperty("os.name").toLowerCase().startsWith("windows")) {
            File profileDir;
            File homeDir;
            String homeDrive = System.getenv("HOMEDRIVE");
            String homePath = System.getenv("HOMEPATH");
            if (homeDrive != null && homeDrive.length() > 0 && homePath != null && homePath.length() > 0 && (homeDir = new File(new File(homeDrive), homePath)).exists()) {
                return homeDir;
            }
            String userProfile = System.getenv("USERPROFILE");
            if (userProfile != null && userProfile.length() > 0 && (profileDir = new File(userProfile)).exists()) {
                return profileDir;
            }
        }
        return null;
    }

    private static File findConfigInHomeDir() {
        File config;
        File homeDir = ClientBuilder.findHomeDir();
        if (homeDir != null && (config = new File(new File(homeDir, ".kube"), "config")).exists()) {
            return config;
        }
        log.debug("Could not find ~/.kube/config");
        return null;
    }

    public static ClientBuilder oldCluster() throws IOException {
        ClientBuilder builder = new ClientBuilder();
        String host = System.getenv("KUBERNETES_SERVICE_HOST");
        String port = System.getenv("KUBERNETES_SERVICE_PORT");
        builder.setBasePath(host, port);
        String token = new String(Files.readAllBytes(Paths.get("/var/run/secrets/kubernetes.io/serviceaccount/token", new String[0])), Charset.defaultCharset());
        builder.setCertificateAuthority(Files.readAllBytes(Paths.get("/var/run/secrets/kubernetes.io/serviceaccount/ca.crt", new String[0])));
        builder.setAuthentication(new AccessTokenAuthentication(token));
        return builder;
    }

    public static ClientBuilder cluster() throws IOException {
        ClientBuilder builder = new ClientBuilder();
        String host = System.getenv("KUBERNETES_SERVICE_HOST");
        String port = System.getenv("KUBERNETES_SERVICE_PORT");
        builder.setBasePath(host, port);
        builder.setCertificateAuthority(Files.readAllBytes(Paths.get("/var/run/secrets/kubernetes.io/serviceaccount/ca.crt", new String[0])));
        builder.setAuthentication(new TokenFileAuthentication("/var/run/secrets/kubernetes.io/serviceaccount/token"));
        return builder;
    }

    protected ClientBuilder setBasePath(String host, String port) {
        try {
            Integer iPort = Integer.valueOf(port);
            URI uri = new URI("https", null, host, iPort, null, null, null);
            this.setBasePath(uri.toString());
        }
        catch (NumberFormatException | URISyntaxException e) {
            throw new IllegalStateException(e);
        }
        return this;
    }

    public static ClientBuilder kubeconfig(KubeConfig config) throws IOException {
        byte[] caBytes;
        ClientBuilder builder = new ClientBuilder();
        String server = config.getServer();
        if (server == null) {
            throw new IllegalArgumentException("No server in kubeconfig");
        }
        if (!server.contains("://")) {
            server = server.contains(":443") ? "https://" + server : "http://" + server;
        }
        if ((caBytes = config.getDataOrFileRelative(config.getCertificateAuthorityData(), config.getCertificateAuthorityFile())) != null) {
            builder.setCertificateAuthority(caBytes);
        }
        builder.setVerifyingSsl(config.verifySSL());
        builder.setBasePath(server);
        builder.setAuthentication(new KubeconfigAuthentication(config));
        return builder;
    }

    public static ApiClient fromCertificateSigningRequest(KubeConfig bootstrapKubeConfig, PrivateKey privateKey, V1CertificateSigningRequest csr) throws IOException, CSRNotApprovedException, ApiException {
        ApiClient bootstrapApiClient = ClientBuilder.kubeconfig(bootstrapKubeConfig).build();
        return ClientBuilder.fromCertificateSigningRequest(bootstrapApiClient, privateKey, csr);
    }

    public static ApiClient fromCertificateSigningRequest(ApiClient bootstrapApiClient, PrivateKey privateKey, V1CertificateSigningRequest csr) throws IOException, CSRNotApprovedException, ApiException {
        byte[] certificateData = CSRUtils.createAndWaitUntilCertificateSigned(bootstrapApiClient, csr);
        InputStream is = bootstrapApiClient.getSslCaCert();
        is.reset();
        ClientBuilder newBuilder = new ClientBuilder();
        newBuilder.setAuthentication(new ClientCertificateAuthentication(certificateData, SSLUtils.dumpKey(privateKey)));
        newBuilder.setBasePath(bootstrapApiClient.getBasePath());
        newBuilder.setVerifyingSsl(bootstrapApiClient.isVerifyingSsl());
        newBuilder.setCertificateAuthority(IOUtils.toByteArray((InputStream)is));
        return newBuilder.build();
    }

    public String getBasePath() {
        return this.basePath;
    }

    public ClientBuilder setBasePath(String basePath) {
        this.basePath = basePath;
        return this;
    }

    public Authentication getAuthentication() {
        return this.authentication;
    }

    public ClientBuilder setAuthentication(Authentication authentication) {
        this.authentication = authentication;
        return this;
    }

    public ClientBuilder setCertificateAuthority(byte[] caCertBytes) {
        this.caCertBytes = caCertBytes;
        return this;
    }

    public boolean isVerifyingSsl() {
        return this.verifyingSsl;
    }

    public ClientBuilder setVerifyingSsl(boolean verifyingSsl) {
        this.verifyingSsl = verifyingSsl;
        return this;
    }

    public ClientBuilder setProtocols(List<Protocol> protocols) {
        this.protocols = protocols;
        return this;
    }

    public List<Protocol> getProtocols() {
        return this.protocols;
    }

    public ClientBuilder setReadTimeout(Duration readTimeout) {
        this.readTimeout = readTimeout;
        return this;
    }

    public Duration getReadTimeout() {
        return this.readTimeout;
    }

    public ClientBuilder setPingInterval(Duration pingInterval) {
        this.pingInterval = pingInterval;
        return this;
    }

    public Duration getPingInterval() {
        return this.pingInterval;
    }

    public String getKeyStorePassphrase() {
        return this.keyStorePassphrase;
    }

    public ClientBuilder setKeyStorePassphrase(String keyStorePassphrase) {
        this.keyStorePassphrase = keyStorePassphrase;
        return this;
    }

    public ApiClient build() {
        ApiClient client = new ApiClient();
        client.setHttpClient(client.getHttpClient().newBuilder().protocols(this.protocols).readTimeout(this.readTimeout).pingInterval(this.pingInterval).build());
        if (this.basePath != null) {
            if (this.basePath.endsWith("/")) {
                this.basePath = this.basePath.substring(0, this.basePath.length() - 1);
            }
            client.setBasePath(this.basePath);
        }
        client.setVerifyingSsl(this.verifyingSsl);
        if (this.authentication != null) {
            if (StringUtils.isNotEmpty((CharSequence)this.keyStorePassphrase) && this.authentication instanceof KubeconfigAuthentication && ((KubeconfigAuthentication)this.authentication).getDelegateAuthentication() instanceof ClientCertificateAuthentication) {
                ((ClientCertificateAuthentication)((KubeconfigAuthentication)this.authentication).getDelegateAuthentication()).setPassphrase(this.keyStorePassphrase);
            }
            this.authentication.provide(client);
        }
        if (this.caCertBytes != null) {
            client.setSslCaCert((InputStream)new ByteArrayInputStream(this.caCertBytes));
        }
        return client;
    }

    private static class KubeConfigEnvParser {
        private KubeConfigEnvParser() {
        }

        private String parseKubeConfigPath(String kubeConfigEnv) {
            if (kubeConfigEnv == null) {
                return null;
            }
            String[] filePaths = kubeConfigEnv.split(File.pathSeparator);
            String kubeConfigPath = filePaths[0];
            if (filePaths.length > 1) {
                log.warn("Found multiple kubeconfigs files, $KUBECONFIG: " + kubeConfigEnv + " using first: {}", (Object)kubeConfigPath);
            }
            return kubeConfigPath;
        }
    }
}

