/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.tree;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import io.trino.sql.tree.AstVisitor;
import io.trino.sql.tree.Identifier;
import io.trino.sql.tree.Node;
import io.trino.sql.tree.NodeLocation;
import io.trino.sql.tree.Query;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class WithQuery
extends Node {
    private final Identifier name;
    private final Query query;
    private final Optional<List<Identifier>> columnNames;

    public WithQuery(Identifier name, Query query, Optional<List<Identifier>> columnNames) {
        this(Optional.empty(), name, query, columnNames);
    }

    public WithQuery(NodeLocation location, Identifier name, Query query, Optional<List<Identifier>> columnNames) {
        this(Optional.of(location), name, query, columnNames);
    }

    private WithQuery(Optional<NodeLocation> location, Identifier name, Query query, Optional<List<Identifier>> columnNames) {
        super(location);
        this.name = name;
        this.query = Objects.requireNonNull(query, "query is null");
        this.columnNames = Objects.requireNonNull(columnNames, "columnNames is null");
    }

    public Identifier getName() {
        return this.name;
    }

    public Query getQuery() {
        return this.query;
    }

    public Optional<List<Identifier>> getColumnNames() {
        return this.columnNames;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitWithQuery(this, context);
    }

    public List<Node> getChildren() {
        return ImmutableList.of((Object)this.query);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("name", (Object)this.name).add("query", (Object)this.query).add("columnNames", this.columnNames).omitNullValues().toString();
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.name, this.query, this.columnNames);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        WithQuery o = (WithQuery)obj;
        return Objects.equals(this.name, o.name) && Objects.equals(this.query, o.query) && Objects.equals(this.columnNames, o.columnNames);
    }

    @Override
    public boolean shallowEquals(Node other) {
        if (!WithQuery.sameClass(this, other)) {
            return false;
        }
        WithQuery otherRelation = (WithQuery)other;
        return this.name.equals(otherRelation.name) && Objects.equals(this.columnNames, otherRelation.columnNames);
    }
}

