/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.gen;

import com.google.common.base.Preconditions;
import io.trino.spi.block.Block;
import io.trino.spi.type.BooleanType;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;

public final class CompilerOperations {
    private CompilerOperations() {
    }

    public static boolean longGreaterThanZero(long value) {
        return value > 0L;
    }

    public static boolean and(boolean left, boolean right) {
        return left && right;
    }

    public static boolean or(boolean left, boolean right) {
        return left || right;
    }

    public static boolean not(boolean value) {
        return !value;
    }

    public static boolean lessThan(int left, int right) {
        return left < right;
    }

    public static boolean greaterThan(int left, int right) {
        return left > right;
    }

    public static boolean in(Object value, Set<?> set) {
        return set.contains(value);
    }

    public static boolean testMask(@Nullable Block masks, int index) {
        if (masks != null) {
            if (masks.isNull(index)) {
                return false;
            }
            return BooleanType.BOOLEAN.getBoolean(masks, index);
        }
        return true;
    }

    public static int optionalChannelToIntOrNegative(Optional<Integer> channel) {
        return channel.orElse(-1);
    }

    public static void validateChannelsListLength(List<Integer> channels, int requiredSize) {
        int channelsSize = channels.size();
        Preconditions.checkArgument((channelsSize == 0 || requiredSize == 0 || channelsSize == requiredSize ? 1 : 0) != 0, (String)"Invalid channels length, expected %s but found: %s", (int)requiredSize, (int)channelsSize);
    }
}

