/*
 * Decompiled with CFR 0.152.
 */
package io.trino.operator;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.trino.operator.OperatorInfo;
import io.trino.spi.Mergeable;

public class HashCollisionsInfo
implements Mergeable<HashCollisionsInfo>,
OperatorInfo {
    public static final String WEIGHTED_HASH_COLLISIONS_PROPERTY = "weightedHashCollisions";
    public static final String WEIGHTED_SUM_SQUARED_HASH_COLLISIONS = "weightedSumSquaredHashCollisions";
    public static final String WEIGHTED_EXPECTED_HASH_COLLISIONS = "weightedExpectedHashCollisions";
    private final double weightedHashCollisions;
    private final double weightedSumSquaredHashCollisions;
    private final double weightedExpectedHashCollisions;

    public static HashCollisionsInfo createHashCollisionsInfo(long inputPositionsCount, double hashCollisionsCount, double expectedHashCollisions) {
        return new HashCollisionsInfo(hashCollisionsCount * (double)inputPositionsCount, hashCollisionsCount * hashCollisionsCount * (double)inputPositionsCount, expectedHashCollisions * (double)inputPositionsCount);
    }

    @JsonCreator
    public HashCollisionsInfo(@JsonProperty(value="weightedHashCollisions") double weightedHashCollisions, @JsonProperty(value="weightedSumSquaredHashCollisions") double weightedSumSquaredHashCollisions, @JsonProperty(value="weightedExpectedHashCollisions") double weightedExpectedHashCollisions) {
        this.weightedHashCollisions = weightedHashCollisions;
        this.weightedSumSquaredHashCollisions = weightedSumSquaredHashCollisions;
        this.weightedExpectedHashCollisions = weightedExpectedHashCollisions;
    }

    @JsonProperty
    public double getWeightedSumSquaredHashCollisions() {
        return this.weightedSumSquaredHashCollisions;
    }

    @JsonProperty
    public double getWeightedHashCollisions() {
        return this.weightedHashCollisions;
    }

    @JsonProperty
    public double getWeightedExpectedHashCollisions() {
        return this.weightedExpectedHashCollisions;
    }

    public HashCollisionsInfo mergeWith(HashCollisionsInfo other) {
        return new HashCollisionsInfo(this.weightedHashCollisions + other.getWeightedHashCollisions(), this.weightedSumSquaredHashCollisions + other.getWeightedSumSquaredHashCollisions(), this.weightedExpectedHashCollisions + other.getWeightedExpectedHashCollisions());
    }
}

