/*
 * Decompiled with CFR 0.152.
 */
package org.iq80.leveldb.impl;

import com.google.common.base.Preconditions;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import org.iq80.leveldb.impl.FileMetaData;
import org.iq80.leveldb.impl.InternalKey;
import org.iq80.leveldb.impl.InternalKeyComparator;
import org.iq80.leveldb.impl.LookupKey;
import org.iq80.leveldb.impl.LookupResult;
import org.iq80.leveldb.impl.ReadStats;
import org.iq80.leveldb.impl.SeekingIterable;
import org.iq80.leveldb.impl.TableCache;
import org.iq80.leveldb.impl.ValueType;
import org.iq80.leveldb.table.UserComparator;
import org.iq80.leveldb.util.InternalTableIterator;
import org.iq80.leveldb.util.Level0Iterator;
import org.iq80.leveldb.util.Slice;

public class Level0
implements SeekingIterable<InternalKey, Slice> {
    private final TableCache tableCache;
    private final InternalKeyComparator internalKeyComparator;
    private final List<FileMetaData> files;
    public static final Comparator<FileMetaData> NEWEST_FIRST = new Comparator<FileMetaData>(){

        @Override
        public int compare(FileMetaData fileMetaData, FileMetaData fileMetaData1) {
            return (int)(fileMetaData1.getNumber() - fileMetaData.getNumber());
        }
    };

    public Level0(List<FileMetaData> files, TableCache tableCache, InternalKeyComparator internalKeyComparator) {
        Objects.requireNonNull(files, "files is null");
        Objects.requireNonNull(tableCache, "tableCache is null");
        Objects.requireNonNull(internalKeyComparator, "internalKeyComparator is null");
        this.files = new ArrayList<FileMetaData>(files);
        this.tableCache = tableCache;
        this.internalKeyComparator = internalKeyComparator;
    }

    public int getLevelNumber() {
        return 0;
    }

    public List<FileMetaData> getFiles() {
        return this.files;
    }

    public Level0Iterator iterator() {
        return new Level0Iterator(this.tableCache, this.files, this.internalKeyComparator);
    }

    public LookupResult get(LookupKey key, ReadStats readStats) {
        if (this.files.isEmpty()) {
            return null;
        }
        ArrayList<FileMetaData> fileMetaDataList = new ArrayList<FileMetaData>(this.files.size());
        for (FileMetaData fileMetaData : this.files) {
            if (this.internalKeyComparator.getUserComparator().compare(key.getUserKey(), fileMetaData.getSmallest().getUserKey()) < 0 || this.internalKeyComparator.getUserComparator().compare(key.getUserKey(), fileMetaData.getLargest().getUserKey()) > 0) continue;
            fileMetaDataList.add(fileMetaData);
        }
        Collections.sort(fileMetaDataList, NEWEST_FIRST);
        readStats.clear();
        for (FileMetaData fileMetaData : fileMetaDataList) {
            InternalTableIterator iterator = this.tableCache.newIterator(fileMetaData);
            iterator.seek(key.getInternalKey());
            if (iterator.hasNext()) {
                Object entry = iterator.next();
                InternalKey internalKey = (InternalKey)entry.getKey();
                Preconditions.checkState((internalKey != null ? 1 : 0) != 0, (String)"Corrupt key for %s", (Object)key.getUserKey().toString(StandardCharsets.UTF_8));
                if (key.getUserKey().equals(internalKey.getUserKey())) {
                    if (internalKey.getValueType() == ValueType.DELETION) {
                        return LookupResult.deleted(key);
                    }
                    if (internalKey.getValueType() == ValueType.VALUE) {
                        return LookupResult.ok(key, (Slice)entry.getValue());
                    }
                }
            }
            if (readStats.getSeekFile() != null) continue;
            readStats.setSeekFile(fileMetaData);
            readStats.setSeekFileLevel(0);
        }
        return null;
    }

    public boolean someFileOverlapsRange(Slice smallestUserKey, Slice largestUserKey) {
        InternalKey smallestInternalKey = new InternalKey(smallestUserKey, 0xFFFFFFFFFFFFFFL, ValueType.VALUE);
        int index = this.findFile(smallestInternalKey);
        UserComparator userComparator = this.internalKeyComparator.getUserComparator();
        return index < this.files.size() && userComparator.compare(largestUserKey, this.files.get(index).getSmallest().getUserKey()) >= 0;
    }

    private int findFile(InternalKey targetKey) {
        if (this.files.isEmpty()) {
            return this.files.size();
        }
        int left = 0;
        int right = this.files.size() - 1;
        while (left < right) {
            int mid = (left + right) / 2;
            if (this.internalKeyComparator.compare(this.files.get(mid).getLargest(), targetKey) < 0) {
                left = mid + 1;
                continue;
            }
            right = mid;
        }
        return right;
    }

    public void addFile(FileMetaData fileMetaData) {
        this.files.add(fileMetaData);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Level0");
        sb.append("{files=").append(this.files);
        sb.append('}');
        return sb.toString();
    }
}

