/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spi.block;

import io.airlift.slice.SizeOf;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.block.Block;
import io.trino.spi.block.DuplicateMapKeyException;
import io.trino.spi.type.MapType;
import java.util.Arrays;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import org.openjdk.jol.info.ClassLayout;

@ThreadSafe
public final class MapHashTables {
    public static final int INSTANCE_SIZE = ClassLayout.parseClass(MapHashTables.class).instanceSize();
    static final int HASH_MULTIPLIER = 2;
    private final MapType mapType;
    @Nullable
    @GuardedBy(value="this")
    private volatile int[] hashTables;

    MapHashTables(MapType mapType, Optional<int[]> hashTables) {
        this.mapType = mapType;
        this.hashTables = hashTables.orElse(null);
    }

    public long getRetainedSizeInBytes() {
        return (long)INSTANCE_SIZE + SizeOf.sizeOf((int[])this.hashTables);
    }

    int[] get() {
        if (this.hashTables == null) {
            throw new IllegalStateException("hashTables are not built");
        }
        return this.hashTables;
    }

    Optional<int[]> tryGet() {
        return Optional.ofNullable(this.hashTables);
    }

    synchronized void growHashTables(int newSize) {
        int[] hashTables = this.hashTables;
        if (hashTables == null) {
            throw new IllegalStateException("hashTables not set");
        }
        if (newSize < hashTables.length) {
            throw new IllegalArgumentException("hashTables size does not match expectedEntryCount");
        }
        int[] newRawHashTables = Arrays.copyOf(hashTables, newSize);
        Arrays.fill(newRawHashTables, hashTables.length, newSize, -1);
        this.hashTables = newRawHashTables;
    }

    void buildAllHashTablesIfNecessary(Block rawKeyBlock, int[] offsets, @Nullable boolean[] mapIsNull) {
        if (this.hashTables == null) {
            this.buildAllHashTables(rawKeyBlock, offsets, mapIsNull);
        }
    }

    private synchronized void buildAllHashTables(Block rawKeyBlock, int[] offsets, @Nullable boolean[] mapIsNull) {
        if (this.hashTables != null) {
            return;
        }
        int[] hashTables = new int[rawKeyBlock.getPositionCount() * 2];
        Arrays.fill(hashTables, -1);
        int hashTableCount = offsets.length - 1;
        for (int i = 0; i < hashTableCount; ++i) {
            int keyOffset = offsets[i];
            int keyCount = offsets[i + 1] - keyOffset;
            if (keyCount < 0) {
                throw new IllegalArgumentException(String.format("Offset is not monotonically ascending. offsets[%s]=%s, offsets[%s]=%s", i, offsets[i], i + 1, offsets[i + 1]));
            }
            if (mapIsNull != null && mapIsNull[i] && keyCount != 0) {
                throw new IllegalArgumentException("A null map must have zero entries");
            }
            this.buildHashTableInternal(rawKeyBlock, keyOffset, keyCount, hashTables);
        }
        this.hashTables = hashTables;
    }

    synchronized void buildHashTable(Block keyBlock, int keyOffset, int keyCount) {
        int[] hashTables = this.hashTables;
        if (hashTables == null) {
            throw new IllegalStateException("hashTables not set");
        }
        this.buildHashTableInternal(keyBlock, keyOffset, keyCount, hashTables);
        this.hashTables = hashTables;
    }

    private void buildHashTableInternal(Block keyBlock, int keyOffset, int keyCount, int[] hashTables) {
        int hashTableOffset = keyOffset * 2;
        int hashTableSize = keyCount * 2;
        int i = 0;
        while (i < keyCount) {
            int hash = this.getHashPosition(keyBlock, keyOffset + i, hashTableSize);
            while (true) {
                if (hashTables[hashTableOffset + hash] == -1) break;
                if (++hash != hashTableSize) continue;
                hash = 0;
            }
            hashTables[hashTableOffset + hash] = i++;
        }
    }

    synchronized void buildHashTableStrict(Block keyBlock, int keyOffset, int keyCount) throws DuplicateMapKeyException {
        int[] hashTables = this.hashTables;
        if (hashTables == null) {
            throw new IllegalStateException("hashTables not set");
        }
        int hashTableOffset = keyOffset * 2;
        int hashTableSize = keyCount * 2;
        int i = 0;
        while (i < keyCount) {
            int hash = this.getHashPosition(keyBlock, keyOffset + i, hashTableSize);
            while (true) {
                Boolean isDuplicateKey;
                if (hashTables[hashTableOffset + hash] == -1) break;
                try {
                    isDuplicateKey = this.mapType.getKeyBlockEqual().invokeExact(keyBlock, keyOffset + i, keyBlock, keyOffset + hashTables[hashTableOffset + hash]);
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (Throwable throwable) {
                    throw new RuntimeException(throwable);
                }
                if (isDuplicateKey == null) {
                    throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "map key cannot be null or contain nulls");
                }
                if (isDuplicateKey.booleanValue()) {
                    throw new DuplicateMapKeyException(keyBlock, keyOffset + i);
                }
                if (++hash != hashTableSize) continue;
                hash = 0;
            }
            hashTables[hashTableOffset + hash] = i++;
        }
        this.hashTables = hashTables;
    }

    private int getHashPosition(Block keyBlock, int position, int hashTableSize) {
        long hashCode;
        if (keyBlock.isNull(position)) {
            throw new IllegalArgumentException("map keys cannot be null");
        }
        try {
            hashCode = this.mapType.getKeyBlockHashCode().invokeExact(keyBlock, position);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable);
        }
        return MapHashTables.computePosition(hashCode, hashTableSize);
    }

    static int computePosition(long hashcode, int hashTableSize) {
        return (int)(Integer.toUnsignedLong(Long.hashCode(hashcode)) * (long)hashTableSize >> 32);
    }
}

