/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spi.block;

class Int2IntOpenHashMap {
    public static final int DEFAULT_RETURN_VALUE = -1;
    private static final int INT_PHI = -1640531527;
    private static final float DEFAULT_LOAD_FACTOR = 0.75f;
    protected transient int[] key;
    protected transient int[] value;
    protected transient int mask;
    protected transient boolean containsNullKey;
    protected transient int n;
    protected transient int maxFill;
    protected final transient int minN;
    protected int size;
    protected final float f;

    public Int2IntOpenHashMap(int expected) {
        this(expected, 0.75f);
    }

    public Int2IntOpenHashMap(int expected, float f) {
        if (f <= 0.0f || f > 1.0f) {
            throw new IllegalArgumentException("Load factor must be greater than 0 and smaller than or equal to 1");
        }
        if (expected < 0) {
            throw new IllegalArgumentException("The expected number of elements must be nonnegative");
        }
        this.f = f;
        this.minN = this.n = Int2IntOpenHashMap.arraySize(expected, f);
        this.mask = this.n - 1;
        this.maxFill = Int2IntOpenHashMap.maxFill(this.n, f);
        this.key = new int[this.n + 1];
        this.value = new int[this.n + 1];
    }

    public int putIfAbsent(int k, int v) {
        int pos = this.find(k);
        if (pos >= 0) {
            return this.value[pos];
        }
        this.insert(-pos - 1, k, v);
        return -1;
    }

    public int get(int k) {
        if (k == 0) {
            return this.containsNullKey ? this.value[this.n] : -1;
        }
        int[] key = this.key;
        int pos = Int2IntOpenHashMap.mix(k) & this.mask;
        int curr = key[pos];
        if (curr == 0) {
            return -1;
        }
        if (k == curr) {
            return this.value[pos];
        }
        do {
            if ((curr = key[pos = pos + 1 & this.mask]) != 0) continue;
            return -1;
        } while (k != curr);
        return this.value[pos];
    }

    public boolean containsKey(int k) {
        if (k == 0) {
            return this.containsNullKey;
        }
        int[] key = this.key;
        int pos = Int2IntOpenHashMap.mix(k) & this.mask;
        int curr = key[pos];
        if (curr == 0) {
            return false;
        }
        if (k == curr) {
            return true;
        }
        do {
            if ((curr = key[pos = pos + 1 & this.mask]) != 0) continue;
            return false;
        } while (k != curr);
        return true;
    }

    private void insert(int pos, int k, int v) {
        if (pos == this.n) {
            this.containsNullKey = true;
        }
        this.key[pos] = k;
        this.value[pos] = v;
        if (this.size++ >= this.maxFill) {
            this.rehash(Int2IntOpenHashMap.arraySize(this.size + 1, this.f));
        }
    }

    private int find(int k) {
        if (k == 0) {
            return this.containsNullKey ? this.n : -(this.n + 1);
        }
        int[] key = this.key;
        int pos = Int2IntOpenHashMap.mix(k) & this.mask;
        int curr = key[pos];
        if (curr == 0) {
            return -(pos + 1);
        }
        if (k == curr) {
            return pos;
        }
        do {
            if ((curr = key[pos = pos + 1 & this.mask]) != 0) continue;
            return -(pos + 1);
        } while (k != curr);
        return pos;
    }

    private void rehash(int newN) {
        int[] key = this.key;
        int[] value = this.value;
        int mask = newN - 1;
        int[] newKey = new int[newN + 1];
        int[] newValue = new int[newN + 1];
        int i = this.n;
        int j = this.realSize();
        while (j-- != 0) {
            --i;
            while (key[i] == 0) {
                --i;
            }
            int pos = Int2IntOpenHashMap.mix(key[i]) & mask;
            if (newKey[pos] != 0) {
                pos = pos + 1 & mask;
                while (newKey[pos] != 0) {
                    pos = pos + 1 & mask;
                }
            }
            newKey[pos] = key[i];
            newValue[pos] = value[i];
        }
        newValue[newN] = value[this.n];
        this.n = newN;
        this.mask = mask;
        this.maxFill = Int2IntOpenHashMap.maxFill(this.n, this.f);
        this.key = newKey;
        this.value = newValue;
    }

    private int realSize() {
        return this.containsNullKey ? this.size - 1 : this.size;
    }

    private static int mix(int x) {
        int h = x * -1640531527;
        return h ^ h >>> 16;
    }

    private static int maxFill(int n, float f) {
        return Math.min((int)Math.ceil((float)n * f), n - 1);
    }

    private static int arraySize(int expected, float f) {
        long s = Math.max(2L, Int2IntOpenHashMap.nextPowerOfTwo((long)Math.ceil((float)expected / f)));
        if (s > 0x40000000L) {
            throw new IllegalArgumentException("Too large (" + expected + " expected elements with load factor " + f + ")");
        }
        return (int)s;
    }

    private static long nextPowerOfTwo(long x) {
        if (x == 0L) {
            return 1L;
        }
        --x;
        x |= x >> 1;
        x |= x >> 2;
        x |= x >> 4;
        x |= x >> 8;
        x |= x >> 16;
        return (x | x >> 32) + 1L;
    }
}

