/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.zip;

import java.io.File;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Set;
import org.zeroturnaround.zip.ZTFilePermissions;
import org.zeroturnaround.zip.ZTFilePermissionsStrategy;
import org.zeroturnaround.zip.ZTZipReflectionUtil;
import org.zeroturnaround.zip.ZipException;

class Java7Nio2ApiPermissionsStrategy
implements ZTFilePermissionsStrategy {
    private final Class<? extends Enum<?>> posixFilePermissionClass;
    private final Class<?> filesClass;
    private final Class<?> pathClass;
    private final Class<? extends Enum<?>> linkOptionClass;
    private final Enum<?>[] linkOptionsArray;
    private final Method toPathMethod;
    private final Method setPosixFilePermissionsMethod;
    private final Method getPosixFilePermissionsMethod;
    private final Object OWNER_READ;
    private final Object OWNER_WRITE;
    private final Object OWNER_EXECUTE;
    private final Object GROUP_READ;
    private final Object GROUP_WRITE;
    private final Object GROUP_EXECUTE;
    private final Object OTHERS_READ;
    private final Object OTHERS_WRITE;
    private final Object OTHERS_EXECUTE;

    public Java7Nio2ApiPermissionsStrategy() {
        if (!Java7Nio2ApiPermissionsStrategy.isPosix()) {
            throw new ZipException("File system does not support POSIX file attributes");
        }
        this.posixFilePermissionClass = ZTZipReflectionUtil.getClassForName("java.nio.file.attribute.PosixFilePermission", Enum.class);
        Enum<?>[] constants = this.posixFilePermissionClass.getEnumConstants();
        this.OWNER_READ = constants[0];
        this.OWNER_WRITE = constants[1];
        this.OWNER_EXECUTE = constants[2];
        this.GROUP_READ = constants[3];
        this.GROUP_WRITE = constants[4];
        this.GROUP_EXECUTE = constants[5];
        this.OTHERS_READ = constants[6];
        this.OTHERS_WRITE = constants[7];
        this.OTHERS_EXECUTE = constants[8];
        this.linkOptionClass = ZTZipReflectionUtil.getClassForName("java.nio.file.LinkOption", Enum.class);
        this.linkOptionsArray = (Enum[])Array.newInstance(this.linkOptionClass, 1);
        this.linkOptionsArray[0] = this.linkOptionClass.getEnumConstants()[0];
        this.filesClass = ZTZipReflectionUtil.getClassForName("java.nio.file.Files", Object.class);
        this.pathClass = ZTZipReflectionUtil.getClassForName("java.nio.file.Path", Object.class);
        this.toPathMethod = ZTZipReflectionUtil.getDeclaredMethod(File.class, "toPath", new Class[0]);
        this.setPosixFilePermissionsMethod = ZTZipReflectionUtil.getDeclaredMethod(this.filesClass, "setPosixFilePermissions", this.pathClass, Set.class);
        this.getPosixFilePermissionsMethod = ZTZipReflectionUtil.getDeclaredMethod(this.filesClass, "getPosixFilePermissions", this.pathClass, this.linkOptionsArray.getClass());
    }

    @Override
    public ZTFilePermissions getPermissions(File file) {
        ZTFilePermissions permissions = new ZTFilePermissions();
        permissions.setDirectory(file.isDirectory());
        Set<?> posixFilePermissions = this.getPosixFilePermissions(file);
        permissions.setOwnerCanRead(posixFilePermissions.contains(this.OWNER_READ));
        permissions.setOwnerCanWrite(posixFilePermissions.contains(this.OWNER_WRITE));
        permissions.setOwnerCanExecute(posixFilePermissions.contains(this.OWNER_EXECUTE));
        permissions.setGroupCanRead(posixFilePermissions.contains(this.GROUP_READ));
        permissions.setGroupCanWrite(posixFilePermissions.contains(this.GROUP_WRITE));
        permissions.setGroupCanExecute(posixFilePermissions.contains(this.GROUP_EXECUTE));
        permissions.setOthersCanRead(posixFilePermissions.contains(this.OTHERS_READ));
        permissions.setOthersCanWrite(posixFilePermissions.contains(this.OTHERS_WRITE));
        permissions.setOthersCanExecute(posixFilePermissions.contains(this.OTHERS_EXECUTE));
        return permissions;
    }

    @Override
    public void setPermissions(File file, ZTFilePermissions permissions) {
        HashSet set = new HashSet();
        this.addIf(permissions.isOwnerCanRead(), set, this.OWNER_READ);
        this.addIf(permissions.isOwnerCanRead(), set, this.OWNER_READ);
        this.addIf(permissions.isOwnerCanWrite(), set, this.OWNER_WRITE);
        this.addIf(permissions.isOwnerCanExecute(), set, this.OWNER_EXECUTE);
        this.addIf(permissions.isGroupCanRead(), set, this.GROUP_READ);
        this.addIf(permissions.isGroupCanWrite(), set, this.GROUP_WRITE);
        this.addIf(permissions.isGroupCanExecute(), set, this.GROUP_EXECUTE);
        this.addIf(permissions.isOthersCanRead(), set, this.OTHERS_READ);
        this.addIf(permissions.isOthersCanWrite(), set, this.OTHERS_WRITE);
        this.addIf(permissions.isOthersCanExecute(), set, this.OTHERS_EXECUTE);
        this.setPosixFilePermissions(file, set);
    }

    private <E> void addIf(boolean condition, Set<E> set, E el) {
        if (condition) {
            set.add(el);
        }
    }

    private Object toPath(File file) {
        return ZTZipReflectionUtil.invoke(this.toPathMethod, file, new Object[0]);
    }

    private void setPosixFilePermissions(File file, Set<?> set) {
        ZTZipReflectionUtil.invoke(this.setPosixFilePermissionsMethod, null, this.toPath(file), set);
    }

    private Set<?> getPosixFilePermissions(File file) {
        return (Set)ZTZipReflectionUtil.invoke(this.getPosixFilePermissionsMethod, null, this.toPath(file), this.linkOptionsArray);
    }

    private static boolean isPosix() {
        Method getDefaultMethod = ZTZipReflectionUtil.getDeclaredMethod(ZTZipReflectionUtil.getClassForName("java.nio.file.FileSystems", Object.class), "getDefault", new Class[0]);
        Method supportedFileAttributeViewsMethod = ZTZipReflectionUtil.getDeclaredMethod(ZTZipReflectionUtil.getClassForName("java.nio.file.FileSystem", Object.class), "supportedFileAttributeViews", new Class[0]);
        Object fileSystem = ZTZipReflectionUtil.invoke(getDefaultMethod, null, new Object[0]);
        Set views = (Set)ZTZipReflectionUtil.invoke(supportedFileAttributeViewsMethod, fileSystem, new Object[0]);
        return views.contains("posix");
    }
}

