/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logmanager.configuration;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import java.util.Properties;
import java.util.ServiceLoader;
import org.jboss.logmanager.Level;
import org.jboss.logmanager.LogContext;
import org.jboss.logmanager.LogContextConfigurator;
import org.jboss.logmanager.Logger;
import org.jboss.logmanager.StandardOutputStreams;
import org.jboss.logmanager.configuration.ContextConfiguration;
import org.jboss.logmanager.configuration.PropertyContextConfiguration;
import org.jboss.logmanager.formatters.PatternFormatter;
import org.jboss.logmanager.handlers.ConsoleHandler;

public class PropertyLogContextConfigurator
implements LogContextConfigurator {
    @Override
    public void configure(LogContext logContext, InputStream inputStream) {
        LogContext context;
        InputStream configIn = inputStream != null ? inputStream : PropertyLogContextConfigurator.findConfiguration();
        LogContext logContext2 = context = logContext == null ? LogContext.getLogContext() : logContext;
        if (configIn != null) {
            Properties properties = new Properties();
            try (InputStreamReader reader = new InputStreamReader(configIn, StandardCharsets.UTF_8);){
                properties.load(reader);
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to configure log manager with configuration file.", e);
            }
            PropertyContextConfiguration configurator = PropertyContextConfiguration.configure(context, properties);
            context.attachIfAbsent(ContextConfiguration.CONTEXT_CONFIGURATION_KEY, configurator);
        } else {
            Iterator<LogContextConfigurator> serviceLoader = ServiceLoader.load(LogContextConfigurator.class, PropertyLogContextConfigurator.class.getClassLoader()).iterator();
            if (serviceLoader.hasNext()) {
                serviceLoader.next().configure(context, null);
            } else {
                ConsoleHandler handler = new ConsoleHandler(new PatternFormatter("%d{yyyy-MM-dd'T'HH:mm:ssXXX} %-5p [%c] (%t) %s%e%n"));
                handler.setLevel(Level.INFO);
                handler.setAutoFlush(true);
                Logger rootLogger = context.getLogger("");
                ((java.util.logging.Logger)rootLogger).setLevel(Level.INFO);
                ((java.util.logging.Logger)rootLogger).addHandler(handler);
            }
        }
    }

    private static InputStream findConfiguration() {
        String propLoc = System.getProperty("logging.configuration");
        if (propLoc != null) {
            try {
                return new URL(propLoc).openStream();
            }
            catch (IOException e) {
                StandardOutputStreams.printError("Unable to read the logging configuration from '%s' (%s)%n", propLoc, e);
            }
        }
        ClassLoader cl = PropertyLogContextConfigurator.class.getClassLoader();
        try {
            return cl.getResourceAsStream("logging.properties");
        }
        catch (Exception ignore) {
            return null;
        }
    }
}

