/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.runtime.configuration;

import io.smallrye.common.net.CidrAddress;
import io.smallrye.common.net.Inet;
import jakarta.annotation.Priority;
import java.io.Serializable;
import org.eclipse.microprofile.config.spi.Converter;

@Priority(value=200)
public class CidrAddressConverter
implements Converter<CidrAddress>,
Serializable {
    private static final long serialVersionUID = 2023552088048952902L;

    public CidrAddress convert(String value) {
        if ((value = value.trim()).isEmpty()) {
            return null;
        }
        CidrAddress result = Inet.parseCidrAddress((String)value);
        if (result == null) {
            throw new IllegalArgumentException("Failed to parse CIDR address \"" + value + "\"");
        }
        return result;
    }
}

