/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.security.runtime;

import io.quarkus.security.ForbiddenException;
import io.quarkus.security.credential.Credential;
import io.quarkus.security.identity.AuthenticationRequestContext;
import io.quarkus.security.identity.SecurityIdentity;
import io.quarkus.security.identity.SecurityIdentityAugmentor;
import io.quarkus.security.runtime.QuarkusPermission;
import io.quarkus.security.spi.runtime.BlockingSecurityExecutor;
import io.smallrye.mutiny.Uni;
import java.security.Permission;
import java.security.Principal;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;

public final class QuarkusPermissionSecurityIdentityAugmentor
implements SecurityIdentityAugmentor {
    private static final Predicate<Throwable> NOT_A_FORBIDDEN_EXCEPTION = new Predicate<Throwable>(){

        @Override
        public boolean test(Throwable throwable) {
            return !(throwable instanceof ForbiddenException);
        }
    };
    private static final Function<Throwable, Throwable> WRAP_WITH_FORBIDDEN_EXCEPTION = new Function<Throwable, Throwable>(){

        @Override
        public Throwable apply(Throwable throwable) {
            return new ForbiddenException(throwable);
        }
    };
    private static final String ROUTING_CONTEXT_ATTRIBUTE = "quarkus.http.routing.context";
    private final BiFunction<SecurityIdentity, Permission, Uni<Boolean>> permissionChecker;

    QuarkusPermissionSecurityIdentityAugmentor(final BlockingSecurityExecutor blockingExecutor) {
        this.permissionChecker = new BiFunction<SecurityIdentity, Permission, Uni<Boolean>>(){

            @Override
            public Uni<Boolean> apply(SecurityIdentity finalIdentity, Permission requiredpermission) {
                if (requiredpermission instanceof QuarkusPermission) {
                    QuarkusPermission quarkusPermission = (QuarkusPermission)requiredpermission;
                    return quarkusPermission.isGranted(finalIdentity, blockingExecutor).onFailure(NOT_A_FORBIDDEN_EXCEPTION).transform(WRAP_WITH_FORBIDDEN_EXCEPTION);
                }
                return Uni.createFrom().item((Object)false);
            }
        };
    }

    public Uni<SecurityIdentity> augment(SecurityIdentity identity, AuthenticationRequestContext context, Map<String, Object> attributes) {
        if (identity.isAnonymous()) {
            return Uni.createFrom().item((Object)identity);
        }
        return Uni.createFrom().item((Object)new PermissionCheckerIdentityDecorator(identity, attributes.get(ROUTING_CONTEXT_ATTRIBUTE), this.permissionChecker));
    }

    public Uni<SecurityIdentity> augment(SecurityIdentity identity, AuthenticationRequestContext context) {
        return this.augment(identity, context, Map.of());
    }

    public int priority() {
        return Integer.MAX_VALUE;
    }

    private static final class PermissionCheckerIdentityDecorator
    implements SecurityIdentity {
        private final SecurityIdentity delegate;
        private final Object routingContext;
        private final BiFunction<SecurityIdentity, Permission, Uni<Boolean>> permissionChecker;

        private PermissionCheckerIdentityDecorator(SecurityIdentity delegate, Object routingContext, BiFunction<SecurityIdentity, Permission, Uni<Boolean>> permissionChecker) {
            this.delegate = delegate;
            this.routingContext = routingContext;
            this.permissionChecker = permissionChecker;
        }

        public Principal getPrincipal() {
            return this.delegate.getPrincipal();
        }

        public <T extends Principal> T getPrincipal(Class<T> clazz) {
            return (T)this.delegate.getPrincipal(clazz);
        }

        public boolean isAnonymous() {
            return false;
        }

        public Set<String> getRoles() {
            return this.delegate.getRoles();
        }

        public boolean hasRole(String s) {
            return this.delegate.hasRole(s);
        }

        public <T extends Credential> T getCredential(Class<T> aClass) {
            return (T)this.delegate.getCredential(aClass);
        }

        public Set<Credential> getCredentials() {
            return this.delegate.getCredentials();
        }

        public <T> T getAttribute(String s) {
            if (QuarkusPermissionSecurityIdentityAugmentor.ROUTING_CONTEXT_ATTRIBUTE.equals(s)) {
                return (T)this.routingContext;
            }
            return (T)this.delegate.getAttribute(s);
        }

        public Map<String, Object> getAttributes() {
            if (this.routingContext != null) {
                HashMap<String, Object> attributes = new HashMap<String, Object>(this.delegate.getAttributes());
                attributes.put(QuarkusPermissionSecurityIdentityAugmentor.ROUTING_CONTEXT_ATTRIBUTE, this.routingContext);
                return attributes;
            }
            return this.delegate.getAttributes();
        }

        public Uni<Boolean> checkPermission(final Permission permission) {
            return this.permissionChecker.apply(this, permission).flatMap((Function)new Function<Boolean, Uni<? extends Boolean>>(){

                @Override
                public Uni<? extends Boolean> apply(Boolean accessGranted) {
                    if (Boolean.TRUE.equals(accessGranted)) {
                        return Uni.createFrom().item((Object)true);
                    }
                    return delegate.checkPermission(permission);
                }
            });
        }

        public boolean checkPermissionBlocking(Permission permission) {
            return (Boolean)this.checkPermission(permission).await().indefinitely();
        }
    }
}

