/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.extension.auth.opa;

import java.io.FileInputStream;
import java.nio.file.Path;
import java.security.KeyStore;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.HttpClients;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManager;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManagerBuilder;
import org.apache.hc.client5.http.io.HttpClientConnectionManager;
import org.apache.hc.client5.http.ssl.DefaultClientTlsStrategy;
import org.apache.hc.client5.http.ssl.NoopHostnameVerifier;
import org.apache.hc.client5.http.ssl.TlsSocketStrategy;
import org.apache.hc.core5.ssl.SSLContexts;
import org.apache.hc.core5.util.Timeout;
import org.apache.polaris.extension.auth.opa.OpaAuthorizationConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OpaHttpClientFactory {
    private static final Logger logger = LoggerFactory.getLogger(OpaHttpClientFactory.class);

    OpaHttpClientFactory() {
    }

    public static CloseableHttpClient createHttpClient(OpaAuthorizationConfig.HttpConfig config) {
        RequestConfig requestConfig = RequestConfig.custom().setResponseTimeout(Timeout.ofMilliseconds((long)config.timeout().toMillis())).build();
        try {
            DefaultClientTlsStrategy tlsStrategy = OpaHttpClientFactory.createTlsStrategy(config);
            PoolingHttpClientConnectionManager connectionManager = PoolingHttpClientConnectionManagerBuilder.create().setTlsSocketStrategy((TlsSocketStrategy)tlsStrategy).build();
            return HttpClients.custom().setConnectionManager((HttpClientConnectionManager)connectionManager).setDefaultRequestConfig(requestConfig).build();
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to create HTTP client for OPA communication", e);
        }
    }

    private static DefaultClientTlsStrategy createTlsStrategy(OpaAuthorizationConfig.HttpConfig config) throws Exception {
        SSLContext sslContext = OpaHttpClientFactory.createSslContext(config);
        if (!config.verifySsl()) {
            return new DefaultClientTlsStrategy(sslContext, (HostnameVerifier)NoopHostnameVerifier.INSTANCE);
        }
        return new DefaultClientTlsStrategy(sslContext);
    }

    private static SSLContext createSslContext(OpaAuthorizationConfig.HttpConfig config) throws Exception {
        if (!config.verifySsl()) {
            logger.warn("SSL verification is disabled for OPA server. This should only be used in development/testing environments.");
            return SSLContexts.custom().loadTrustMaterial(null, (chain, authType) -> true).build();
        }
        if (config.trustStorePath().isPresent()) {
            Path trustStorePath = config.trustStorePath().get();
            logger.info("Loading custom trust store for OPA SSL verification: {}", (Object)trustStorePath);
            KeyStore trustStore = KeyStore.getInstance(KeyStore.getDefaultType());
            try (FileInputStream trustStoreStream = new FileInputStream(trustStorePath.toFile());){
                String trustStorePassword = config.trustStorePassword().orElse(null);
                trustStore.load(trustStoreStream, trustStorePassword != null ? trustStorePassword.toCharArray() : null);
            }
            return SSLContexts.custom().loadTrustMaterial(trustStore, null).build();
        }
        logger.debug("Using default system trust store for OPA SSL verification");
        return SSLContexts.createDefault();
    }
}

