/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.faulttolerance.basicconfig;

import io.smallrye.faulttolerance.autoconfig.MethodDescriptor;
import java.util.Optional;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;

public final class ConfigUtil {
    private static final String OLD_FALLBACK = "Fallback/enabled";

    private static String newKey(String newSuffix, String configKey) {
        return "smallrye.faulttolerance.\"" + configKey + "\"." + newSuffix;
    }

    private static String oldKey(String oldSuffix, String configKey) {
        return configKey + "/" + oldSuffix;
    }

    private static String newKey(String newSuffix) {
        return "smallrye.faulttolerance.global." + newSuffix;
    }

    private static String oldKey(String oldSuffix) {
        return oldSuffix;
    }

    public static boolean isEnabled(String newSuffix, String oldSuffix, MethodDescriptor method) {
        Config config = ConfigProvider.getConfig();
        Optional onMethodNew = config.getOptionalValue(ConfigUtil.newKey(newSuffix, method.declaringClass.getName() + "/" + method.name), String.class);
        if (onMethodNew.isPresent()) {
            return Boolean.parseBoolean((String)onMethodNew.get());
        }
        Optional onMethod = config.getOptionalValue(ConfigUtil.oldKey(oldSuffix, method.declaringClass.getName() + "/" + method.name), String.class);
        if (onMethod.isPresent()) {
            return Boolean.parseBoolean((String)onMethod.get());
        }
        Optional onClassNew = config.getOptionalValue(ConfigUtil.newKey(newSuffix, method.declaringClass.getName()), String.class);
        if (onClassNew.isPresent()) {
            return Boolean.parseBoolean((String)onClassNew.get());
        }
        Optional onClass = config.getOptionalValue(ConfigUtil.oldKey(oldSuffix, method.declaringClass.getName()), String.class);
        if (onClass.isPresent()) {
            return Boolean.parseBoolean((String)onClass.get());
        }
        Optional onGlobalNew = config.getOptionalValue(ConfigUtil.newKey(newSuffix), String.class);
        if (onGlobalNew.isPresent()) {
            return Boolean.parseBoolean((String)onGlobalNew.get());
        }
        Optional onGlobal = config.getOptionalValue(ConfigUtil.oldKey(oldSuffix), String.class);
        if (onGlobal.isPresent()) {
            return Boolean.parseBoolean((String)onGlobal.get());
        }
        if (OLD_FALLBACK.equals(oldSuffix)) {
            return true;
        }
        Optional ftEnabledNew = config.getOptionalValue("smallrye.faulttolerance.enabled", Boolean.class);
        if (ftEnabledNew.isPresent()) {
            return (Boolean)ftEnabledNew.get();
        }
        Optional ftEnabled = config.getOptionalValue("MP_Fault_Tolerance_NonFallback_Enabled", Boolean.class);
        if (ftEnabled.isPresent()) {
            return (Boolean)ftEnabled.get();
        }
        return true;
    }

    public static boolean isEnabled(String newSuffix, String oldSuffix, String id) {
        Config config = ConfigProvider.getConfig();
        Optional identifiedNew = config.getOptionalValue(ConfigUtil.newKey(newSuffix, id), String.class);
        if (identifiedNew.isPresent()) {
            return Boolean.parseBoolean((String)identifiedNew.get());
        }
        Optional identified = config.getOptionalValue(ConfigUtil.oldKey(oldSuffix, id), String.class);
        if (identified.isPresent()) {
            return Boolean.parseBoolean((String)identified.get());
        }
        Optional globalNew = config.getOptionalValue(ConfigUtil.newKey(newSuffix), String.class);
        if (globalNew.isPresent()) {
            return Boolean.parseBoolean((String)globalNew.get());
        }
        Optional global = config.getOptionalValue(ConfigUtil.oldKey(oldSuffix), String.class);
        if (global.isPresent()) {
            return Boolean.parseBoolean((String)global.get());
        }
        if (OLD_FALLBACK.equals(oldSuffix)) {
            return true;
        }
        Optional ftEnabledNew = config.getOptionalValue("smallrye.faulttolerance.enabled", Boolean.class);
        if (ftEnabledNew.isPresent()) {
            return (Boolean)ftEnabledNew.get();
        }
        Optional ftEnabled = config.getOptionalValue("MP_Fault_Tolerance_NonFallback_Enabled", Boolean.class);
        if (ftEnabled.isPresent()) {
            return (Boolean)ftEnabled.get();
        }
        return true;
    }
}

