/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.http.netty.implementation;

import com.azure.core.http.netty.implementation.ChallengeHolder;
import com.azure.core.util.AuthorizationChallengeHandler;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.DefaultFullHttpRequest;
import io.netty.handler.codec.http.HttpClientCodec;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.handler.proxy.HttpProxyHandler;
import io.netty.handler.proxy.ProxyConnectException;
import io.netty.handler.proxy.ProxyHandler;
import io.netty.util.AttributeKey;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;

public final class HttpProxyHandler
extends ProxyHandler {
    private static final String VALIDATION_ERROR_TEMPLATE = "The '%s' returned in the 'Proxy-Authentication-Info' header doesn't match the value sent in the 'Proxy-Authorization' header. Sent: %s, received: %s.";
    private static final AttributeKey<String> PROXY_AUTHORIZATION_KEY = AttributeKey.newInstance((String)"ProxyAuthorization");
    private static final String NONE = "none";
    private static final String HTTP = "http";
    private static final String CNONCE = "cnonce";
    private static final String NC = "nc";
    private static final String AUTH_BASIC = "basic";
    private static final String AUTH_DIGEST = "digest";
    private static final String PROXY_METHOD = HttpMethod.CONNECT.name();
    private static final String PROXY_URI_PATH = "/";
    private static final byte[] NO_BYTES = new byte[0];
    private static final Supplier<byte[]> NO_BODY = () -> NO_BYTES;
    private static final ClientLogger LOGGER = new ClientLogger(HttpProxyHandler.class);
    private final AuthorizationChallengeHandler challengeHandler;
    private final AtomicReference<ChallengeHolder> proxyChallengeHolderReference;
    private final HttpClientCodec codec;
    private String authScheme = null;
    private HttpResponseStatus status;
    private HttpHeaders innerHeaders;

    public HttpProxyHandler(InetSocketAddress proxyAddress, AuthorizationChallengeHandler challengeHandler, AtomicReference<ChallengeHolder> proxyChallengeHolderReference) {
        super((SocketAddress)proxyAddress);
        this.challengeHandler = challengeHandler;
        this.proxyChallengeHolderReference = proxyChallengeHolderReference;
        this.codec = new HttpClientCodec();
    }

    public String protocol() {
        return HTTP;
    }

    public String authScheme() {
        return this.authScheme == null ? NONE : this.authScheme;
    }

    protected void addCodec(ChannelHandlerContext ctx) {
        ctx.pipeline().addBefore(ctx.name(), null, (ChannelHandler)this.codec);
    }

    protected void removeEncoder(ChannelHandlerContext ctx) {
        this.codec.removeOutboundHandler();
    }

    protected void removeDecoder(ChannelHandlerContext ctx) {
        this.codec.removeInboundHandler();
    }

    protected Object newInitialMessage(ChannelHandlerContext ctx) {
        String authorizationHeader;
        InetSocketAddress destinationAddress = (InetSocketAddress)this.destinationAddress();
        String hostString = HttpUtil.formatHostnameForHttp((InetSocketAddress)destinationAddress);
        int port = destinationAddress.getPort();
        String url = hostString + ":" + port;
        String hostHeader = port == 80 || port == 443 ? url : hostString;
        DefaultFullHttpRequest request = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.CONNECT, url, Unpooled.EMPTY_BUFFER, false);
        request.headers().set((CharSequence)HttpHeaderNames.HOST, (Object)hostHeader);
        if (this.challengeHandler != null && !CoreUtils.isNullOrEmpty((CharSequence)(authorizationHeader = this.createAuthorizationHeader()))) {
            this.authScheme = AUTH_DIGEST.regionMatches(true, 0, authorizationHeader, 0, 6) ? AUTH_DIGEST : AUTH_BASIC;
            request.headers().set("Proxy-Authorization", (Object)authorizationHeader);
            ctx.channel().attr(PROXY_AUTHORIZATION_KEY).set((Object)authorizationHeader);
        }
        return request;
    }

    private String createAuthorizationHeader() {
        String authorizationHeader = this.challengeHandler.attemptToPipelineAuthorization(PROXY_METHOD, PROXY_URI_PATH, NO_BODY);
        if (!CoreUtils.isNullOrEmpty((CharSequence)authorizationHeader)) {
            return authorizationHeader;
        }
        ChallengeHolder proxyChallengeHolder = this.proxyChallengeHolderReference.get();
        if (proxyChallengeHolder != null) {
            List<Map<String, String>> digestChallenges = proxyChallengeHolder.getDigestChallenges();
            if (!CoreUtils.isNullOrEmpty(digestChallenges)) {
                authorizationHeader = this.challengeHandler.handleDigest(PROXY_METHOD, PROXY_URI_PATH, digestChallenges, NO_BODY);
            }
            if (CoreUtils.isNullOrEmpty((CharSequence)authorizationHeader) && proxyChallengeHolder.hasBasicChallenge()) {
                authorizationHeader = this.challengeHandler.handleBasic();
            }
        }
        return authorizationHeader;
    }

    protected boolean handleResponse(ChannelHandlerContext ctx, Object o) throws ProxyConnectException {
        boolean responseComplete;
        if (o instanceof HttpResponse) {
            if (this.status != null) {
                throw LOGGER.logExceptionAsWarning(new RuntimeException("Received too many responses for a request"));
            }
            HttpResponse response = (HttpResponse)o;
            this.status = response.status();
            this.innerHeaders = response.headers();
            if (response.status().code() == 407) {
                this.proxyChallengeHolderReference.set(HttpProxyHandler.extractChallengesFromHeaders(response.headers()));
            } else if (response.status().code() == 200) {
                this.validateProxyAuthenticationInfo(response.headers().get("Proxy-Authentication-Info"), (String)ctx.channel().attr(PROXY_AUTHORIZATION_KEY).get());
            }
        }
        if ((responseComplete = o instanceof LastHttpContent) && this.status == null) {
            throw new HttpProxyHandler.HttpProxyConnectException("Never received response for CONNECT request.", this.innerHeaders);
        }
        return responseComplete;
    }

    private static ChallengeHolder extractChallengesFromHeaders(HttpHeaders headers) {
        boolean hasBasicChallenge = false;
        ArrayList<Map<String, String>> digestChallenges = new ArrayList<Map<String, String>>();
        for (String proxyAuthenticationHeader : headers.getAll("Proxy-Authenticate")) {
            if (AUTH_BASIC.regionMatches(true, 0, proxyAuthenticationHeader, 0, 5)) {
                hasBasicChallenge = true;
                continue;
            }
            if (!AUTH_DIGEST.regionMatches(true, 0, proxyAuthenticationHeader, 0, 6)) continue;
            HashMap<String, String> digestChallenge = new HashMap<String, String>();
            String challengePieces = proxyAuthenticationHeader.substring(7);
            for (String challengePiece : challengePieces.split(",")) {
                int indexOfEqual = challengePiece.indexOf(61);
                if (indexOfEqual < 0) continue;
                digestChallenge.put(challengePiece.substring(0, indexOfEqual).trim(), challengePiece.substring(indexOfEqual + 1).trim().replace("\"", ""));
            }
            digestChallenges.add(digestChallenge);
        }
        return new ChallengeHolder(hasBasicChallenge, digestChallenges);
    }

    private void validateProxyAuthenticationInfo(String infoHeader, String authorizationHeader) {
        if (CoreUtils.isNullOrEmpty((CharSequence)infoHeader)) {
            return;
        }
        Map authenticationInfoPieces = AuthorizationChallengeHandler.parseAuthenticationOrAuthorizationHeader((String)infoHeader);
        Map authorizationPieces = AuthorizationChallengeHandler.parseAuthenticationOrAuthorizationHeader((String)authorizationHeader);
        HttpProxyHandler.validateProxyAuthenticationInfoValue(CNONCE, authenticationInfoPieces, authorizationPieces);
        HttpProxyHandler.validateProxyAuthenticationInfoValue(NC, authenticationInfoPieces, authorizationPieces);
        this.challengeHandler.consumeAuthenticationInfoHeader(authenticationInfoPieces);
    }

    private static void validateProxyAuthenticationInfoValue(String name, Map<String, String> authenticationInfoPieces, Map<String, String> authorizationPieces) {
        if (authenticationInfoPieces.containsKey(name)) {
            String sentValue = authorizationPieces.get(name);
            String receivedValue = authenticationInfoPieces.get(name);
            if (!receivedValue.equalsIgnoreCase(sentValue)) {
                throw LOGGER.logExceptionAsError((RuntimeException)new IllegalStateException(String.format(VALIDATION_ERROR_TEMPLATE, name, sentValue, receivedValue)));
            }
        }
    }
}

