/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kerby.kerberos.kerb.crypto.key;

import java.security.GeneralSecurityException;
import org.apache.kerby.kerberos.kerb.KrbException;
import org.apache.kerby.kerberos.kerb.crypto.enc.provider.AesProvider;
import org.apache.kerby.kerberos.kerb.crypto.key.DkKeyMaker;
import org.apache.kerby.kerberos.kerb.crypto.util.Pbkdf;

public class AesKeyMaker
extends DkKeyMaker {
    public AesKeyMaker(AesProvider encProvider) {
        super(encProvider);
    }

    @Override
    public byte[] random2Key(byte[] randomBits) throws KrbException {
        return randomBits;
    }

    @Override
    public byte[] str2key(String string, String salt, byte[] param) throws KrbException {
        byte[] random;
        int iterCount = AesKeyMaker.getIterCount(param, 4096);
        byte[] saltBytes = AesKeyMaker.getSaltBytes(salt, null);
        int keySize = this.encProvider().keySize();
        try {
            random = Pbkdf.pbkdf2(string.toCharArray(), saltBytes, iterCount, keySize);
        }
        catch (GeneralSecurityException e) {
            throw new KrbException("pbkdf2 failed", (Throwable)e);
        }
        byte[] tmpKey = this.random2Key(random);
        return this.dk(tmpKey, KERBEROS_CONSTANT);
    }
}

