/*
 * Decompiled with CFR 0.152.
 */
package org.apache.polaris.persistence.relational.jdbc.models;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.polaris.core.entity.PolarisGrantRecord;
import org.apache.polaris.persistence.relational.jdbc.DatabaseType;
import org.apache.polaris.persistence.relational.jdbc.models.Converter;

public class ModelGrantRecord
implements Converter<PolarisGrantRecord> {
    public static final String TABLE_NAME = "GRANT_RECORDS";
    public static final List<String> ALL_COLUMNS = List.of("securable_catalog_id", "securable_id", "grantee_catalog_id", "grantee_id", "privilege_code");
    private long securableCatalogId;
    private long securableId;
    private long granteeCatalogId;
    private long granteeId;
    private int privilegeCode;

    public long getSecurableCatalogId() {
        return this.securableCatalogId;
    }

    public long getSecurableId() {
        return this.securableId;
    }

    public long getGranteeCatalogId() {
        return this.granteeCatalogId;
    }

    public long getGranteeId() {
        return this.granteeId;
    }

    public int getPrivilegeCode() {
        return this.privilegeCode;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public PolarisGrantRecord fromResultSet(ResultSet rs) throws SQLException {
        ModelGrantRecord modelGrantRecord = ModelGrantRecord.builder().securableCatalogId(rs.getObject("securable_catalog_id", Long.class)).securableId(rs.getObject("securable_id", Long.class)).granteeCatalogId(rs.getObject("grantee_catalog_id", Long.class)).granteeId(rs.getObject("grantee_id", Long.class)).privilegeCode(rs.getObject("privilege_code", Integer.class)).build();
        return ModelGrantRecord.toGrantRecord(modelGrantRecord);
    }

    @Override
    public Map<String, Object> toMap(DatabaseType databaseType) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("securable_catalog_id", this.securableCatalogId);
        map.put("securable_id", this.securableId);
        map.put("grantee_catalog_id", this.granteeCatalogId);
        map.put("grantee_id", this.granteeId);
        map.put("privilege_code", this.privilegeCode);
        return map;
    }

    public static ModelGrantRecord fromGrantRecord(PolarisGrantRecord record) {
        if (record == null) {
            return null;
        }
        return ModelGrantRecord.builder().securableCatalogId(record.getSecurableCatalogId()).securableId(record.getSecurableId()).granteeCatalogId(record.getGranteeCatalogId()).granteeId(record.getGranteeId()).privilegeCode(record.getPrivilegeCode()).build();
    }

    public static PolarisGrantRecord toGrantRecord(ModelGrantRecord model) {
        if (model == null) {
            return null;
        }
        return new PolarisGrantRecord(model.getSecurableCatalogId(), model.getSecurableId(), model.getGranteeCatalogId(), model.getGranteeId(), model.getPrivilegeCode());
    }

    public static final class Builder {
        private final ModelGrantRecord grantRecord = new ModelGrantRecord();

        private Builder() {
        }

        public Builder securableCatalogId(long securableCatalogId) {
            this.grantRecord.securableCatalogId = securableCatalogId;
            return this;
        }

        public Builder securableId(long securableId) {
            this.grantRecord.securableId = securableId;
            return this;
        }

        public Builder granteeCatalogId(long granteeCatalogId) {
            this.grantRecord.granteeCatalogId = granteeCatalogId;
            return this;
        }

        public Builder granteeId(long granteeId) {
            this.grantRecord.granteeId = granteeId;
            return this;
        }

        public Builder privilegeCode(int privilegeCode) {
            this.grantRecord.privilegeCode = privilegeCode;
            return this;
        }

        public ModelGrantRecord build() {
            return this.grantRecord;
        }
    }
}

