/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.cmdline;

import java.io.PrintStream;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import opennlp.tools.commons.Internal;
import opennlp.tools.log.LogPrintStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
public class PerformanceMonitor {
    private static final Logger logger = LoggerFactory.getLogger(PerformanceMonitor.class);
    private final ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1, runnable -> {
        Thread thread = new Thread(runnable);
        thread.setName("opennlp.tools.cmdline.PerformanceMonitor");
        thread.setDaemon(true);
        return thread;
    });
    private final String unit;
    private ScheduledFuture<?> beeperHandle;
    private volatile long startTime = -1L;
    private volatile int counter;
    private final PrintStream out;

    public PerformanceMonitor(PrintStream out, String unit) {
        this.out = out;
        this.unit = unit;
    }

    public PerformanceMonitor(String unit) {
        this((PrintStream)new LogPrintStream(logger), unit);
    }

    public boolean isStarted() {
        return this.startTime != -1L;
    }

    public void incrementCounter(int increment) {
        if (!this.isStarted()) {
            throw new IllegalStateException("Must be started first!");
        }
        if (increment < 0) {
            throw new IllegalArgumentException("increment must be zero or positive but was " + increment + "!");
        }
        this.counter += increment;
    }

    public void incrementCounter() {
        this.incrementCounter(1);
    }

    public void start() {
        if (this.isStarted()) {
            throw new IllegalStateException("Already started!");
        }
        this.startTime = System.currentTimeMillis();
    }

    public void startAndPrintThroughput() {
        this.start();
        Runnable beeper = new Runnable(){
            private long lastTimeStamp;
            private int lastCount;
            {
                this.lastTimeStamp = PerformanceMonitor.this.startTime;
                this.lastCount = PerformanceMonitor.this.counter;
            }

            @Override
            public void run() {
                int deltaCount = PerformanceMonitor.this.counter - this.lastCount;
                long timePassedSinceLastCount = System.currentTimeMillis() - this.lastTimeStamp;
                double currentThroughput = timePassedSinceLastCount > 0L ? (double)deltaCount / ((double)timePassedSinceLastCount / 1000.0) : 0.0;
                long totalTimePassed = System.currentTimeMillis() - PerformanceMonitor.this.startTime;
                double averageThroughput = totalTimePassed > 0L ? (double)PerformanceMonitor.this.counter / ((double)totalTimePassed / 1000.0) : 0.0;
                PerformanceMonitor.this.out.printf("current: %.1f " + PerformanceMonitor.this.unit + "/s avg: %.1f " + PerformanceMonitor.this.unit + "/s total: %d " + PerformanceMonitor.this.unit + "%n", currentThroughput, averageThroughput, PerformanceMonitor.this.counter);
                this.lastTimeStamp = System.currentTimeMillis();
                this.lastCount = PerformanceMonitor.this.counter;
            }
        };
        this.beeperHandle = this.scheduler.scheduleAtFixedRate(beeper, 1L, 1L, TimeUnit.SECONDS);
    }

    public void stopAndPrintFinalResult() {
        if (!this.isStarted()) {
            throw new IllegalStateException("Must be started first!");
        }
        if (this.beeperHandle != null) {
            this.beeperHandle.cancel(false);
        }
        this.scheduler.shutdown();
        long timePassed = System.currentTimeMillis() - this.startTime;
        double average = timePassed > 0L ? (double)this.counter / ((double)timePassed / 1000.0) : 0.0;
        this.out.printf("Average: %.1f " + this.unit + "/s %n", average);
        this.out.println("Total: " + this.counter + " " + this.unit);
        this.out.println("Runtime: " + (double)timePassed / 1000.0 + "s");
    }
}

