/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.util.wordvector;

import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import opennlp.tools.util.wordvector.WordVector;
import opennlp.tools.util.wordvector.WordVectorType;

class DoubleArrayVector
implements WordVector {
    private final double[] vector;

    DoubleArrayVector(double[] vector) {
        this.vector = vector;
    }

    public WordVectorType getDataType() {
        return WordVectorType.DOUBLE;
    }

    public float getAsFloat(int index) {
        return (float)this.getAsDouble(index);
    }

    public double getAsDouble(int index) {
        return this.vector[index];
    }

    public FloatBuffer toFloatBuffer() {
        float[] floatVector = new float[this.vector.length];
        for (int i = 0; i < floatVector.length; ++i) {
            floatVector[i] = (float)this.vector[i];
        }
        return FloatBuffer.wrap(floatVector).asReadOnlyBuffer();
    }

    public DoubleBuffer toDoubleBuffer() {
        return DoubleBuffer.wrap(this.vector).asReadOnlyBuffer();
    }

    public int dimension() {
        return this.vector.length;
    }
}

