/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.uhighlight;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.FilterLeafReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.PostingsEnum;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.MultiTermQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryVisitor;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.TwoPhaseIterator;
import org.apache.lucene.search.Weight;
import org.apache.lucene.search.highlight.WeightedSpanTerm;
import org.apache.lucene.search.highlight.WeightedSpanTermExtractor;
import org.apache.lucene.search.spans.SpanCollector;
import org.apache.lucene.search.spans.SpanQuery;
import org.apache.lucene.search.spans.SpanScorer;
import org.apache.lucene.search.spans.Spans;
import org.apache.lucene.search.uhighlight.OffsetsEnum;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.PriorityQueue;

public class PhraseHelper {
    public static final PhraseHelper NONE = new PhraseHelper((Query)new MatchAllDocsQuery(), "_ignored_", s -> false, spanQuery -> null, query -> null, true);
    private final String fieldName;
    private final Set<BytesRef> positionInsensitiveTerms;
    private final Set<SpanQuery> spanQueries;
    private final boolean willRewrite;
    private final Predicate<String> fieldMatcher;

    public PhraseHelper(final Query query, String field, final Predicate<String> fieldMatcher, final Function<SpanQuery, Boolean> rewriteQueryPred, final Function<Query, Collection<Query>> preExtractRewriteFunction, final boolean ignoreQueriesNeedingRewrite) {
        this.fieldName = field;
        this.fieldMatcher = fieldMatcher;
        this.positionInsensitiveTerms = new HashSet<BytesRef>();
        this.spanQueries = new HashSet<SpanQuery>();
        final boolean[] mustRewriteHolder = new boolean[]{false};
        new WeightedSpanTermExtractor(field){
            {
                super(defaultField);
                this.setExpandMultiTermQuery(true);
                try {
                    this.extract(query, 1.0f, null);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }

            @Override
            protected void extract(Query query2, float boost, Map<String, WeightedSpanTerm> terms) throws IOException {
                Collection newQueriesToExtract = (Collection)preExtractRewriteFunction.apply(query2);
                if (newQueriesToExtract != null) {
                    for (Query newQuery : newQueriesToExtract) {
                        this.extract(newQuery, boost, terms);
                    }
                } else {
                    super.extract(query2, boost, terms);
                }
            }

            @Override
            protected boolean isQueryUnsupported(Class<? extends Query> clazz) {
                if (clazz.isAssignableFrom(MultiTermQuery.class)) {
                    return true;
                }
                return true;
            }

            @Override
            protected void extractWeightedTerms(Map<String, WeightedSpanTerm> terms, Query query2, float boost) {
                query2.visit(new QueryVisitor(){

                    public boolean acceptField(String field) {
                        return fieldMatcher.test(field);
                    }

                    public void consumeTerms(Query query, Term ... terms) {
                        for (Term term : terms) {
                            PhraseHelper.this.positionInsensitiveTerms.add(term.bytes());
                        }
                    }
                });
            }

            @Override
            protected void extractWeightedSpanTerms(Map<String, WeightedSpanTerm> terms, SpanQuery spanQuery, float boost) throws IOException {
                HashSet<String> fieldNameSet = new HashSet<String>();
                this.collectSpanQueryFields(spanQuery, fieldNameSet);
                for (String spanField : fieldNameSet) {
                    if (fieldMatcher.test(spanField)) continue;
                    return;
                }
                boolean mustRewriteQuery = this.mustRewriteQuery(spanQuery);
                if (ignoreQueriesNeedingRewrite && mustRewriteQuery) {
                    return;
                }
                mustRewriteHolder[0] = mustRewriteHolder[0] | mustRewriteQuery;
                PhraseHelper.this.spanQueries.add(spanQuery);
            }

            @Override
            protected boolean mustRewriteQuery(SpanQuery spanQuery) {
                Boolean rewriteQ = (Boolean)rewriteQueryPred.apply(spanQuery);
                return rewriteQ != null ? rewriteQ.booleanValue() : super.mustRewriteQuery(spanQuery);
            }
        };
        this.willRewrite = mustRewriteHolder[0];
    }

    public Set<SpanQuery> getSpanQueries() {
        return this.spanQueries;
    }

    public boolean hasPositionSensitivity() {
        return !this.spanQueries.isEmpty();
    }

    public boolean willRewrite() {
        return this.willRewrite;
    }

    public BytesRef[] getAllPositionInsensitiveTerms() {
        Object[] result = this.positionInsensitiveTerms.toArray(new BytesRef[this.positionInsensitiveTerms.size()]);
        Arrays.sort(result);
        return result;
    }

    public void createOffsetsEnumsForSpans(LeafReader leafReader, int docId, List<OffsetsEnum> results) throws IOException {
        leafReader = new SingleFieldWithOffsetsFilterLeafReader((LeafReader)leafReader, this.fieldName);
        IndexSearcher searcher = new IndexSearcher((IndexReader)leafReader);
        searcher.setQueryCache(null);
        PriorityQueue<Spans> spansPriorityQueue = new PriorityQueue<Spans>(this.spanQueries.size()){

            protected boolean lessThan(Spans a, Spans b) {
                return a.startPosition() <= b.startPosition();
            }
        };
        for (Query query : this.spanQueries) {
            TwoPhaseIterator twoPhaseIterator;
            Weight weight = searcher.createWeight(searcher.rewrite(query), ScoreMode.COMPLETE_NO_SCORES, 1.0f);
            Scorer scorer = weight.scorer(leafReader.getContext());
            if (scorer == null || ((twoPhaseIterator = scorer.twoPhaseIterator()) != null ? twoPhaseIterator.approximation().advance(docId) != docId || !twoPhaseIterator.matches() : scorer.iterator().advance(docId) != docId)) continue;
            Spans spans = ((SpanScorer)scorer).getSpans();
            assert (spans.docID() == docId);
            if (spans.nextStartPosition() == Integer.MAX_VALUE) continue;
            spansPriorityQueue.add((Object)spans);
        }
        OffsetSpanCollector spanCollector = new OffsetSpanCollector();
        while (spansPriorityQueue.size() > 0) {
            Spans spans = (Spans)spansPriorityQueue.top();
            spans.collect((SpanCollector)spanCollector);
            if (spans.nextStartPosition() == Integer.MAX_VALUE) {
                spansPriorityQueue.pop();
                continue;
            }
            spansPriorityQueue.updateTop();
        }
        results.addAll(spanCollector.termToOffsetsEnums.values());
    }

    private static class SpanCollectedOffsetsEnum
    extends OffsetsEnum {
        private final BytesRef term;
        private final int[] startOffsets;
        private final int[] endOffsets;
        private int numPairs = 0;
        private int enumIdx = -1;

        private SpanCollectedOffsetsEnum(BytesRef term, int postingsFreq) {
            this.term = term;
            this.startOffsets = new int[postingsFreq];
            this.endOffsets = new int[postingsFreq];
        }

        void add(int startOffset, int endOffset) {
            int shiftLen;
            int pairIdx;
            assert (this.enumIdx == -1) : "bad state";
            for (pairIdx = this.numPairs - 1; pairIdx >= 0; --pairIdx) {
                int iStartOffset = this.startOffsets[pairIdx];
                int iEndOffset = this.endOffsets[pairIdx];
                int cmp = Integer.compare(iStartOffset, startOffset);
                if (cmp == 0) {
                    cmp = Integer.compare(iEndOffset, endOffset);
                }
                if (cmp == 0) {
                    return;
                }
                if (cmp < 0) break;
            }
            if ((shiftLen = this.numPairs - (pairIdx + 1)) > 0) {
                System.arraycopy(this.startOffsets, pairIdx + 1, this.startOffsets, pairIdx + 2, shiftLen);
                System.arraycopy(this.endOffsets, pairIdx + 1, this.endOffsets, pairIdx + 2, shiftLen);
            }
            this.startOffsets[pairIdx + 1] = startOffset;
            this.endOffsets[pairIdx + 1] = endOffset;
            ++this.numPairs;
        }

        @Override
        public boolean nextPosition() throws IOException {
            return ++this.enumIdx < this.numPairs;
        }

        @Override
        public int freq() throws IOException {
            return this.numPairs;
        }

        @Override
        public BytesRef getTerm() throws IOException {
            return this.term;
        }

        @Override
        public int startOffset() throws IOException {
            return this.startOffsets[this.enumIdx];
        }

        @Override
        public int endOffset() throws IOException {
            return this.endOffsets[this.enumIdx];
        }
    }

    private class OffsetSpanCollector
    implements SpanCollector {
        Map<BytesRef, SpanCollectedOffsetsEnum> termToOffsetsEnums = new HashMap<BytesRef, SpanCollectedOffsetsEnum>();

        private OffsetSpanCollector() {
        }

        public void collectLeaf(PostingsEnum postings, int position, Term term) throws IOException {
            if (!PhraseHelper.this.fieldMatcher.test(term.field())) {
                return;
            }
            SpanCollectedOffsetsEnum offsetsEnum = this.termToOffsetsEnums.get(term.bytes());
            if (offsetsEnum == null) {
                if (PhraseHelper.this.positionInsensitiveTerms.contains(term.bytes())) {
                    return;
                }
                offsetsEnum = new SpanCollectedOffsetsEnum(term.bytes(), postings.freq());
                this.termToOffsetsEnums.put(term.bytes(), offsetsEnum);
            }
            offsetsEnum.add(postings.startOffset(), postings.endOffset());
        }

        public void reset() {
        }
    }

    private static final class SingleFieldWithOffsetsFilterLeafReader
    extends FilterLeafReader {
        final String fieldName;

        SingleFieldWithOffsetsFilterLeafReader(LeafReader in, String fieldName) {
            super(in);
            this.fieldName = fieldName;
        }

        public FieldInfos getFieldInfos() {
            throw new UnsupportedOperationException();
        }

        public Terms terms(String field) throws IOException {
            return new FilterLeafReader.FilterTerms(super.terms(this.fieldName)){

                public TermsEnum iterator() throws IOException {
                    return new FilterLeafReader.FilterTermsEnum(this.in.iterator()){

                        public PostingsEnum postings(PostingsEnum reuse, int flags) throws IOException {
                            return super.postings(reuse, flags | 0x38);
                        }
                    };
                }
            };
        }

        public NumericDocValues getNormValues(String field) throws IOException {
            return super.getNormValues(this.fieldName);
        }

        public IndexReader.CacheHelper getCoreCacheHelper() {
            return null;
        }

        public IndexReader.CacheHelper getReaderCacheHelper() {
            return null;
        }
    }
}

