/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.htmlunit.xpath.axes;

import net.sourceforge.htmlunit.xpath.Expression;
import net.sourceforge.htmlunit.xpath.XPathVisitor;
import net.sourceforge.htmlunit.xpath.axes.LocPathIterator;
import net.sourceforge.htmlunit.xpath.functions.FuncLast;
import net.sourceforge.htmlunit.xpath.functions.FuncPosition;
import net.sourceforge.htmlunit.xpath.functions.Function;
import net.sourceforge.htmlunit.xpath.objects.XNumber;
import net.sourceforge.htmlunit.xpath.operations.Div;
import net.sourceforge.htmlunit.xpath.operations.Minus;
import net.sourceforge.htmlunit.xpath.operations.Mod;
import net.sourceforge.htmlunit.xpath.operations.Mult;
import net.sourceforge.htmlunit.xpath.operations.Number;
import net.sourceforge.htmlunit.xpath.operations.Plus;

public class HasPositionalPredChecker
extends XPathVisitor {
    private boolean m_hasPositionalPred = false;
    private int m_predDepth = 0;

    public static boolean check(LocPathIterator path) {
        HasPositionalPredChecker hppc = new HasPositionalPredChecker();
        path.callVisitors(hppc);
        return hppc.m_hasPositionalPred;
    }

    @Override
    public boolean visitFunction(Function func) {
        if (func instanceof FuncPosition || func instanceof FuncLast) {
            this.m_hasPositionalPred = true;
        }
        return true;
    }

    @Override
    public boolean visitPredicate(Expression pred) {
        ++this.m_predDepth;
        if (this.m_predDepth == 1) {
            if (pred instanceof XNumber || pred instanceof Div || pred instanceof Plus || pred instanceof Minus || pred instanceof Mod || pred instanceof Mult || pred instanceof Number || pred instanceof Function) {
                this.m_hasPositionalPred = true;
            } else {
                pred.callVisitors(this);
            }
        }
        --this.m_predDepth;
        return false;
    }
}

