/*
 * Decompiled with CFR 0.152.
 */
package crawlercommons.sitemaps;

import crawlercommons.sitemaps.AbstractSiteMap;
import crawlercommons.sitemaps.SiteMapURL;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class SiteMap
extends AbstractSiteMap {
    private String baseUrl;
    private List<SiteMapURL> urlList = new ArrayList<SiteMapURL>();

    public SiteMap() {
        this.setProcessed(false);
    }

    public SiteMap(URL url) {
        this();
        this.setUrl(url);
    }

    public SiteMap(String url) {
        this();
        this.setUrl(url);
    }

    public SiteMap(URL url, Date lastModified) {
        this(url);
        this.setLastModified(lastModified);
    }

    public SiteMap(String url, String lastModified) {
        this(url);
        this.setLastModified(lastModified);
    }

    public Collection<SiteMapURL> getSiteMapUrls() {
        return this.urlList;
    }

    private void setUrl(URL url) {
        this.url = url;
        this.setBaseUrl(url);
    }

    private void setUrl(String url) {
        try {
            this.url = new URI(url).toURL();
            this.setBaseUrl(this.url);
        }
        catch (IllegalArgumentException | MalformedURLException | URISyntaxException e) {
            this.url = null;
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder().append("url = \"").append(this.url).append("\", lastMod = ").append(this.getLastModified() == null ? "null" : W3C_FULLDATE_FORMATTER_UTC.format(this.getLastModified().toInstant())).append(", type = ").append((Object)this.getType()).append(", processed = ").append(this.isProcessed()).append(", urlListSize = ").append(this.urlList.size());
        return sb.toString();
    }

    private void setBaseUrl(URL sitemapUrl) {
        String path = sitemapUrl.getPath();
        int lastPathDelimPos = path.lastIndexOf(47);
        path = lastPathDelimPos < 0 ? "/" : path.substring(0, lastPathDelimPos + 1);
        try {
            this.baseUrl = new URI(sitemapUrl.getProtocol(), null, sitemapUrl.getHost(), sitemapUrl.getPort(), path, null, null).toURL().toString();
        }
        catch (MalformedURLException | URISyntaxException e) {
            this.baseUrl = sitemapUrl.toString();
        }
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public void addSiteMapUrl(SiteMapURL url) {
        this.urlList.add(url);
    }

    @Override
    public boolean isIndex() {
        return false;
    }
}

