/*
 * Decompiled with CFR 0.152.
 */
package crawlercommons.robots;

import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;

public abstract class BaseRobotRules
implements Serializable {
    public static final long UNSET_CRAWL_DELAY = Long.MIN_VALUE;
    private long _crawlDelay = Long.MIN_VALUE;
    private boolean _deferVisits = false;
    private boolean _matchedWildcard = false;
    private LinkedHashSet<String> _sitemaps = new LinkedHashSet();

    public abstract boolean isAllowed(String var1);

    public abstract boolean isAllowed(URL var1);

    public abstract boolean isAllowAll();

    public abstract boolean isAllowNone();

    public long getCrawlDelay() {
        return this._crawlDelay;
    }

    public void setCrawlDelay(long crawlDelay) {
        this._crawlDelay = crawlDelay;
    }

    public boolean isDeferVisits() {
        return this._deferVisits;
    }

    public void setDeferVisits(boolean deferVisits) {
        this._deferVisits = deferVisits;
    }

    public boolean isMatchedWildcard() {
        return this._matchedWildcard;
    }

    public void setMatchedWildcard(boolean matchedWildcard) {
        this._matchedWildcard = matchedWildcard;
    }

    public void addSitemap(String sitemap) {
        this._sitemaps.add(sitemap);
    }

    public List<String> getSitemaps() {
        return new ArrayList<String>(this._sitemaps);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this._crawlDelay ^ this._crawlDelay >>> 32);
        result = 31 * result + (this._deferVisits ? 1231 : 1237);
        result = 31 * result + (this._sitemaps == null ? 0 : this._sitemaps.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BaseRobotRules other = (BaseRobotRules)obj;
        if (this._crawlDelay != other._crawlDelay) {
            return false;
        }
        if (this._deferVisits != other._deferVisits) {
            return false;
        }
        return !(this._sitemaps == null ? other._sitemaps != null : !this._sitemaps.equals(other._sitemaps));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass()).append(":\n");
        long delay = this.getCrawlDelay();
        if (delay == Long.MIN_VALUE) {
            sb.append(" - no crawl delay\n");
        } else {
            sb.append(" - crawl delay: ").append(delay).append('\n');
        }
        List<String> sitemaps = this.getSitemaps();
        int nSitemaps = sitemaps.size();
        if (nSitemaps == 0) {
            sb.append(" - no sitemap URLs\n");
        } else {
            sb.append(" - number of sitemap URLs: ").append(nSitemaps).append('\n');
            int numOfSitemapsToShow = Math.min(nSitemaps, 10);
            for (int i = 0; i < numOfSitemapsToShow; ++i) {
                sb.append(sitemaps.get(i)).append("\n");
            }
        }
        return sb.toString();
    }
}

