/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import kafka.network.RequestChannel;
import kafka.server.ClientQuotaManager;
import kafka.server.ClientQuotaManagerConfig;
import kafka.server.ClientRequestQuotaManager$;
import kafka.server.QuotaType$Request$;
import kafka.utils.QuotaUtils$;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.metrics.MeasurableStat;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.QuotaViolationException;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.metrics.stats.Rate;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.quota.ClientQuotaCallback;
import scala.Function1;
import scala.Option;
import scala.Some;
import scala.collection.immutable.Map;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u0005eu!B\u0011#\u0011\u00039c!B\u0015#\u0011\u0003Q\u0003\"B\u0019\u0002\t\u0003\u0011\u0004bB\u001a\u0002\u0005\u0004%\t\u0001\u000e\u0005\u0007q\u0005\u0001\u000b\u0011B\u001b\t\u000fe\n!\u0019!C\u0001u!1a(\u0001Q\u0001\nmBqaP\u0001C\u0002\u0013%\u0001\t\u0003\u0004J\u0003\u0001\u0006I!\u0011\u0004\u0005S\t\u0002!\n\u0003\u0005O\u0013\t\u0015\r\u0011\"\u0003P\u0011!\u0019\u0016B!A!\u0002\u0013\u0001\u0006\u0002\u0003+\n\u0005\u000b\u0007I\u0011B+\t\u0011\tL!\u0011!Q\u0001\nYC\u0001bY\u0005\u0003\u0006\u0004%I\u0001\u001a\u0005\tW&\u0011\t\u0011)A\u0005K\"AA.\u0003BC\u0002\u0013%Q\u000e\u0003\u0005y\u0013\t\u0005\t\u0015!\u0003o\u0011!I\u0018B!b\u0001\n\u0013Q\b\"CA\u0006\u0013\t\u0005\t\u0015!\u0003|\u0011\u0019\t\u0014\u0002\"\u0001\u0002\u000e!A\u00111D\u0005C\u0002\u0013%!\bC\u0004\u0002\u001e%\u0001\u000b\u0011B\u001e\t\u0013\u0005}\u0011B1A\u0005\n\u0005\u0005\u0002\u0002CA\u0016\u0013\u0001\u0006I!a\t\t\u0013\u00055\u0012B1A\u0005\u0002\u0005=\u0002\u0002CA\u001c\u0013\u0001\u0006I!!\r\t\u000f\u0005e\u0012\u0002\"\u0001\u0002<!9\u0011qI\u0005\u0005\u0002\u0005%\u0003bBA7\u0013\u0011\u0005\u0011q\u000e\u0005\b\u0003gJA\u0011KA;\u0011\u001d\t\u0019)\u0003C)\u0003\u000bCq!!%\n\t\u0013\t\u0019*A\rDY&,g\u000e\u001e*fcV,7\u000f^)v_R\fW*\u00198bO\u0016\u0014(BA\u0012%\u0003\u0019\u0019XM\u001d<fe*\tQ%A\u0003lC\u001a\\\u0017m\u0001\u0001\u0011\u0005!\nQ\"\u0001\u0012\u00033\rc\u0017.\u001a8u%\u0016\fX/Z:u#V|G/Y'b]\u0006<WM]\n\u0003\u0003-\u0002\"\u0001L\u0018\u000e\u00035R\u0011AL\u0001\u0006g\u000e\fG.Y\u0005\u0003a5\u0012a!\u00118z%\u00164\u0017A\u0002\u001fj]&$h\bF\u0001(\u0003iq\u0015M\\8t)>\u0004VM]2f]R\fw-\u001a)feN+7m\u001c8e+\u0005)\u0004C\u0001\u00177\u0013\t9TF\u0001\u0004E_V\u0014G.Z\u0001\u001c\u001d\u0006twn\u001d+p!\u0016\u00148-\u001a8uC\u001e,\u0007+\u001a:TK\u000e|g\u000e\u001a\u0011\u0002a\u0011+g-Y;mi&s\u0017m\u0019;jm\u0016,\u00050Z7qiN+gn]8s\u000bb\u0004\u0018N]1uS>tG+[7f'\u0016\u001cwN\u001c3t+\u0005Y\u0004C\u0001\u0017=\u0013\tiTF\u0001\u0003M_:<\u0017!\r#fM\u0006,H\u000e^%oC\u000e$\u0018N^3Fq\u0016l\u0007\u000f^*f]N|'/\u0012=qSJ\fG/[8o)&lWmU3d_:$7\u000fI\u0001\u0011\u000bb,W\u000e\u001d;TK:\u001cxN\u001d(b[\u0016,\u0012!\u0011\t\u0003\u0005\u001ek\u0011a\u0011\u0006\u0003\t\u0016\u000bA\u0001\\1oO*\ta)\u0001\u0003kCZ\f\u0017B\u0001%D\u0005\u0019\u0019FO]5oO\u0006\tR\t_3naR\u001cVM\\:pe:\u000bW.\u001a\u0011\u0014\u0005%Y\u0005C\u0001\u0015M\u0013\ti%E\u0001\nDY&,g\u000e^)v_R\fW*\u00198bO\u0016\u0014\u0018AB2p]\u001aLw-F\u0001Q!\tA\u0013+\u0003\u0002SE\tA2\t\\5f]R\fVo\u001c;b\u001b\u0006t\u0017mZ3s\u0007>tg-[4\u0002\u000f\r|gNZ5hA\u00059Q.\u001a;sS\u000e\u001cX#\u0001,\u0011\u0005]\u0003W\"\u0001-\u000b\u0005QK&B\u0001.\\\u0003\u0019\u0019w.\\7p]*\u0011Q\u0005\u0018\u0006\u0003;z\u000ba!\u00199bG\",'\"A0\u0002\u0007=\u0014x-\u0003\u0002b1\n9Q*\u001a;sS\u000e\u001c\u0018\u0001C7fiJL7m\u001d\u0011\u0002\tQLW.Z\u000b\u0002KB\u0011a-[\u0007\u0002O*\u0011\u0001.W\u0001\u0006kRLGn]\u0005\u0003U\u001e\u0014A\u0001V5nK\u0006)A/[7fA\u0005\u0001B\u000f\u001b:fC\u0012t\u0015-\\3Qe\u00164\u0017\u000e_\u000b\u0002]B\u0011qN\u001e\b\u0003aR\u0004\"!]\u0017\u000e\u0003IT!a\u001d\u0014\u0002\rq\u0012xn\u001c;?\u0013\t)X&\u0001\u0004Qe\u0016$WMZ\u0005\u0003\u0011^T!!^\u0017\u0002#QD'/Z1e\u001d\u0006lW\r\u0015:fM&D\b%A\u0007rk>$\u0018mQ1mY\n\f7m[\u000b\u0002wB\u0019A\u0006 @\n\u0005ul#AB(qi&|g\u000eE\u0002\u0000\u0003\u000fi!!!\u0001\u000b\t\u0005\r\u0011QA\u0001\u0006cV|G/\u0019\u0006\u0003GmKA!!\u0003\u0002\u0002\t\u00192\t\\5f]R\fVo\u001c;b\u0007\u0006dGNY1dW\u0006q\u0011/^8uC\u000e\u000bG\u000e\u001c2bG.\u0004C\u0003DA\b\u0003#\t\u0019\"!\u0006\u0002\u0018\u0005e\u0001C\u0001\u0015\n\u0011\u0015qE\u00031\u0001Q\u0011\u0015!F\u00031\u0001W\u0011\u0015\u0019G\u00031\u0001f\u0011\u0015aG\u00031\u0001o\u0011\u0015IH\u00031\u0001|\u0003Ei\u0017\r\u001f+ie>$H\u000f\\3US6,Wj]\u0001\u0013[\u0006DH\u000b\u001b:piRdW\rV5nK6\u001b\b%\u0001\tfq\u0016l\u0007\u000f^'fiJL7MT1nKV\u0011\u00111\u0005\t\u0005\u0003K\t9#D\u0001Z\u0013\r\tI#\u0017\u0002\u000b\u001b\u0016$(/[2OC6,\u0017!E3yK6\u0004H/T3ue&\u001cg*Y7fA\u0005aQ\r_3naR\u001cVM\\:peV\u0011\u0011\u0011\u0007\t\u0004/\u0006M\u0012bAA\u001b1\n11+\u001a8t_J\fQ\"\u001a=f[B$8+\u001a8t_J\u0004\u0013\u0001\u0004:fG>\u0014H-\u0012=f[B$H\u0003BA\u001f\u0003\u0007\u00022\u0001LA \u0013\r\t\t%\f\u0002\u0005+:LG\u000f\u0003\u0004\u0002Fm\u0001\r!N\u0001\u0006m\u0006dW/Z\u0001 [\u0006L(-\u001a*fG>\u0014H-\u00118e\u000f\u0016$H\u000b\u001b:piRdW\rV5nK6\u001bHCBA&\u0003#\nI\u0007E\u0002-\u0003\u001bJ1!a\u0014.\u0005\rIe\u000e\u001e\u0005\b\u0003'b\u0002\u0019AA+\u0003\u001d\u0011X-];fgR\u0004B!a\u0016\u0002d9!\u0011\u0011LA0\u001b\t\tYFC\u0002\u0002^\u0011\nqA\\3uo>\u00148.\u0003\u0003\u0002b\u0005m\u0013A\u0004*fcV,7\u000f^\"iC:tW\r\\\u0005\u0005\u0003K\n9GA\u0004SKF,Xm\u001d;\u000b\t\u0005\u0005\u00141\f\u0005\u0007\u0003Wb\u0002\u0019A\u001e\u0002\rQLW.Z't\u0003Ei\u0017-\u001f2f%\u0016\u001cwN\u001d3Fq\u0016l\u0007\u000f\u001e\u000b\u0005\u0003{\t\t\bC\u0004\u0002Tu\u0001\r!!\u0016\u0002\u0019QD'o\u001c;uY\u0016$\u0016.\\3\u0015\u000bm\n9(!!\t\u000f\u0005ed\u00041\u0001\u0002|\u0005\tQ\rE\u0002X\u0003{J1!a Y\u0005]\tVo\u001c;b-&|G.\u0019;j_:,\u0005pY3qi&|g\u000e\u0003\u0004\u0002ly\u0001\raO\u0001\u0016G2LWM\u001c;Rk>$\u0018-T3ue&\u001cg*Y7f)\u0011\t\u0019#a\"\t\u000f\u0005%u\u00041\u0001\u0002\f\u0006y\u0011/^8uC6+GO]5d)\u0006<7\u000fE\u0003p\u0003\u001bsg.C\u0002\u0002\u0010^\u00141!T1q\u0003Eq\u0017M\\8t)>\u0004VM]2f]R\fw-\u001a\u000b\u0004k\u0005U\u0005BBALA\u0001\u00071(A\u0003oC:|7\u000f")
public class ClientRequestQuotaManager
extends ClientQuotaManager {
    private final ClientQuotaManagerConfig config;
    private final Metrics metrics;
    private final Time time;
    private final String threadNamePrefix;
    private final Option<ClientQuotaCallback> quotaCallback;
    private final long maxThrottleTimeMs;
    private final MetricName exemptMetricName;
    private final Sensor exemptSensor;

    public static long DefaultInactiveExemptSensorExpirationTimeSeconds() {
        return ClientRequestQuotaManager$.MODULE$.DefaultInactiveExemptSensorExpirationTimeSeconds();
    }

    public static double NanosToPercentagePerSecond() {
        return ClientRequestQuotaManager$.MODULE$.NanosToPercentagePerSecond();
    }

    private ClientQuotaManagerConfig config() {
        return this.config;
    }

    private Metrics metrics() {
        return this.metrics;
    }

    private Time time() {
        return this.time;
    }

    private String threadNamePrefix() {
        return this.threadNamePrefix;
    }

    private Option<ClientQuotaCallback> quotaCallback() {
        return this.quotaCallback;
    }

    private long maxThrottleTimeMs() {
        return this.maxThrottleTimeMs;
    }

    private MetricName exemptMetricName() {
        return this.exemptMetricName;
    }

    public Sensor exemptSensor() {
        return this.exemptSensor;
    }

    public void recordExempt(double value) {
        this.exemptSensor().record(value);
    }

    public int maybeRecordAndGetThrottleTimeMs(RequestChannel.Request request, long timeMs) {
        if (this.quotasEnabled()) {
            request.recordNetworkThreadTimeCallback_$eq((Option<Function1<Object, BoxedUnit>>)new Some((JFunction1.mcVJ.sp & Serializable & scala.Serializable)timeNanos -> this.recordNoThrottle(request.session(), request.header().clientId(), this.nanosToPercentage(timeNanos))));
            return this.recordAndGetThrottleTimeMs(request.session(), request.header().clientId(), this.nanosToPercentage(request.requestThreadTimeNanos()), timeMs);
        }
        return 0;
    }

    public void maybeRecordExempt(RequestChannel.Request request) {
        if (this.quotasEnabled()) {
            request.recordNetworkThreadTimeCallback_$eq((Option<Function1<Object, BoxedUnit>>)new Some((JFunction1.mcVJ.sp & Serializable & scala.Serializable)timeNanos -> this.recordExempt(this.nanosToPercentage(timeNanos))));
            this.recordExempt(this.nanosToPercentage(request.requestThreadTimeNanos()));
            return;
        }
    }

    @Override
    public long throttleTime(QuotaViolationException e, long timeMs) {
        return QuotaUtils$.MODULE$.boundedThrottleTime(e, this.maxThrottleTimeMs(), timeMs);
    }

    @Override
    public MetricName clientQuotaMetricName(Map<String, String> quotaMetricTags) {
        return this.metrics().metricName("request-time", QuotaType$Request$.MODULE$.toString(), "Tracking request-time per user/client-id", (java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter(quotaMetricTags).asJava());
    }

    private double nanosToPercentage(long nanos) {
        return (double)nanos * ClientRequestQuotaManager$.MODULE$.NanosToPercentagePerSecond();
    }

    public ClientRequestQuotaManager(ClientQuotaManagerConfig config, Metrics metrics, Time time, String threadNamePrefix, Option<ClientQuotaCallback> quotaCallback) {
        this.config = config;
        this.metrics = metrics;
        this.time = time;
        this.threadNamePrefix = threadNamePrefix;
        this.quotaCallback = quotaCallback;
        super(config, metrics, QuotaType$Request$.MODULE$, time, threadNamePrefix, quotaCallback);
        this.maxThrottleTimeMs = TimeUnit.SECONDS.toMillis(config.quotaWindowSizeSeconds());
        this.exemptMetricName = metrics.metricName("exempt-request-time", QuotaType$Request$.MODULE$.toString(), "Tracking exempt-request-time utilization percentage");
        this.exemptSensor = this.getOrCreateSensor(ClientRequestQuotaManager$.MODULE$.kafka$server$ClientRequestQuotaManager$$ExemptSensorName(), ClientRequestQuotaManager$.MODULE$.DefaultInactiveExemptSensorExpirationTimeSeconds(), (Function1<Sensor, BoxedUnit>)(Function1 & Serializable & scala.Serializable)sensor -> {
            sensor.add(this.exemptMetricName(), (MeasurableStat)new Rate());
            return BoxedUnit.UNIT;
        });
    }
}

