/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nutch.util;

import java.net.MalformedURLException;
import java.net.URL;
import java.nio.ByteBuffer;
import org.apache.commons.lang3.StringUtils;
import org.apache.nutch.util.StringUtil;

public class TableUtil {
    public static final ByteBuffer YES_VAL = ByteBuffer.wrap(new byte[]{121});

    public static String reverseUrl(String urlString) throws MalformedURLException {
        return TableUtil.reverseUrl(new URL(urlString));
    }

    public static String reverseUrl(URL url) {
        String host = url.getHost();
        String file = url.getFile();
        String protocol = url.getProtocol();
        int port = url.getPort();
        StringBuilder buf = new StringBuilder();
        TableUtil.reverseAppendSplits(host, buf);
        buf.append(':');
        buf.append(protocol);
        if (port != -1) {
            buf.append(':');
            buf.append(port);
        }
        if (file.length() > 0 && '/' != file.charAt(0)) {
            buf.append('/');
        }
        buf.append(file);
        return buf.toString();
    }

    public static String unreverseUrl(String reversedUrl) {
        StringBuilder buf = new StringBuilder(reversedUrl.length() + 2);
        int pathBegin = reversedUrl.indexOf(47);
        if (pathBegin == -1) {
            pathBegin = reversedUrl.length();
        }
        String sub = reversedUrl.substring(0, pathBegin);
        String[] splits = StringUtils.splitPreserveAllTokens((String)sub, (char)':');
        buf.append(splits[1]);
        buf.append("://");
        TableUtil.reverseAppendSplits(splits[0], buf);
        if (splits.length == 3) {
            buf.append(':');
            buf.append(splits[2]);
        }
        buf.append(reversedUrl.substring(pathBegin));
        return buf.toString();
    }

    public static String getReversedHost(String reversedUrl) {
        return reversedUrl.substring(0, reversedUrl.indexOf(58));
    }

    private static void reverseAppendSplits(String string, StringBuilder buf) {
        String[] splits = StringUtils.split((String)string, (char)'.');
        if (splits.length > 0) {
            for (int i = splits.length - 1; i > 0; --i) {
                buf.append(splits[i]);
                buf.append('.');
            }
            buf.append(splits[0]);
        } else {
            buf.append(string);
        }
    }

    public static String reverseHost(String hostName) {
        StringBuilder buf = new StringBuilder();
        TableUtil.reverseAppendSplits(hostName, buf);
        return buf.toString();
    }

    public static String unreverseHost(String reversedHostName) {
        return TableUtil.reverseHost(reversedHostName);
    }

    public static String toString(CharSequence utf8) {
        return utf8 == null ? null : StringUtil.cleanField(utf8.toString());
    }
}

