/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jexl3.internal;

import org.apache.commons.jexl3.JexlBuilder;
import org.apache.commons.jexl3.JexlContext;
import org.apache.commons.jexl3.JexlOptions;
import org.apache.commons.jexl3.internal.Engine;
import org.apache.commons.jexl3.internal.Frame;
import org.apache.commons.jexl3.internal.Interpreter;
import org.apache.commons.jexl3.internal.LexicalScope;
import org.apache.commons.jexl3.internal.Scope;
import org.apache.commons.jexl3.internal.TemplateInterpreter;
import org.apache.commons.jexl3.parser.ASTArrayAccess;
import org.apache.commons.jexl3.parser.ASTAssignment;
import org.apache.commons.jexl3.parser.ASTEQNode;
import org.apache.commons.jexl3.parser.ASTIdentifier;
import org.apache.commons.jexl3.parser.ASTNENode;
import org.apache.commons.jexl3.parser.ASTNullpNode;
import org.apache.commons.jexl3.parser.ASTReference;
import org.apache.commons.jexl3.parser.ASTTernaryNode;
import org.apache.commons.jexl3.parser.JexlNode;

public class Engine32
extends Engine {
    static Object getVariable(Interpreter ii, Frame frame, LexicalScope block, ASTIdentifier identifier) {
        Object value;
        int symbol = identifier.getSymbol();
        if ((ii.options.isLexicalShade() || identifier.isLexical()) && identifier.isShaded()) {
            return ii.undefinedVariable(identifier, identifier.getName());
        }
        if (symbol >= 0 && frame.has(symbol) && (value = frame.get(symbol)) != Scope.UNDEFINED) {
            return value;
        }
        String name = identifier.getName();
        Object value2 = ii.context.get(name);
        if (value2 == null && !ii.context.has(name)) {
            boolean ignore;
            boolean bl = ignore = ii.isSafe() && (symbol >= 0 || identifier.jjtGetParent() instanceof ASTAssignment) || identifier.jjtGetParent() instanceof ASTReference;
            if (!ignore) {
                return ii.unsolvableVariable(identifier, name, true);
            }
        }
        return value2;
    }

    static boolean isTernaryProtected(Interpreter ii, JexlNode startNode) {
        JexlNode node = startNode;
        for (JexlNode walk = node.jjtGetParent(); walk != null; walk = walk.jjtGetParent()) {
            if (walk instanceof ASTTernaryNode || walk instanceof ASTNullpNode || walk instanceof ASTEQNode || walk instanceof ASTNENode) {
                return node == walk.jjtGetChild(0);
            }
            if (!(walk instanceof ASTReference) && !(walk instanceof ASTArrayAccess)) break;
            node = walk;
        }
        return false;
    }

    public Engine32() {
    }

    public Engine32(JexlBuilder conf) {
        super(conf);
    }

    @Override
    protected Interpreter createInterpreter(JexlContext context, Frame frame, JexlOptions opts) {
        return new Interpreter(this, opts, context, frame){

            @Override
            protected Object getVariable(Frame frame, LexicalScope block, ASTIdentifier identifier) {
                return Engine32.getVariable(this, frame, block, identifier);
            }

            @Override
            protected boolean isStrictOperand(JexlNode node) {
                return false;
            }

            @Override
            protected boolean isTernaryProtected(JexlNode node) {
                return Engine32.isTernaryProtected(this, node);
            }
        };
    }

    @Override
    protected Interpreter createTemplateInterpreter(TemplateInterpreter.Arguments args) {
        return new TemplateInterpreter(args){

            @Override
            protected Object getVariable(Frame frame, LexicalScope block, ASTIdentifier identifier) {
                return Engine32.getVariable(this, frame, block, identifier);
            }

            @Override
            protected boolean isStrictOperand(JexlNode node) {
                return false;
            }

            @Override
            protected boolean isTernaryProtected(JexlNode node) {
                return Engine32.isTernaryProtected(this, node);
            }
        };
    }
}

