/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.core.userdetails;

import org.jspecify.annotations.Nullable;
import org.springframework.security.core.AuthenticationException;

public class UsernameNotFoundException
extends AuthenticationException {
    private static final long serialVersionUID = 1410688585992297006L;
    private static final String DEFAULT_USER_NOT_FOUND_MESSAGE = "user not found";
    private final @Nullable String name;

    public UsernameNotFoundException(String msg) {
        super(msg);
        this.name = null;
    }

    public UsernameNotFoundException(String msg, Throwable cause) {
        super(msg, cause);
        this.name = null;
    }

    private UsernameNotFoundException(String msg, String name) {
        super(msg);
        this.name = name;
    }

    private UsernameNotFoundException(String msg, String name, Throwable cause) {
        super(msg, cause);
        this.name = name;
    }

    public static UsernameNotFoundException fromUsername(String username) {
        return new UsernameNotFoundException(DEFAULT_USER_NOT_FOUND_MESSAGE, username);
    }

    public static UsernameNotFoundException fromUsername(String username, Throwable cause) {
        return new UsernameNotFoundException(DEFAULT_USER_NOT_FOUND_MESSAGE, username, cause);
    }

    public @Nullable String getName() {
        return this.name;
    }
}

