/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.core.authority;

import java.time.Instant;
import java.util.Objects;
import org.jspecify.annotations.Nullable;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.util.Assert;

public final class FactorGrantedAuthority
implements GrantedAuthority {
    public static final String AUTHORIZATION_CODE_AUTHORITY = "FACTOR_AUTHORIZATION_CODE";
    public static final String BEARER_AUTHORITY = "FACTOR_BEARER";
    public static final String CAS_AUTHORITY = "FACTOR_CAS";
    public static final String OTT_AUTHORITY = "FACTOR_OTT";
    public static final String PASSWORD_AUTHORITY = "FACTOR_PASSWORD";
    public static final String SAML_RESPONSE_AUTHORITY = "FACTOR_SAML_RESPONSE";
    public static final String WEBAUTHN_AUTHORITY = "FACTOR_WEBAUTHN";
    public static final String X509_AUTHORITY = "FACTOR_X509";
    private static final long serialVersionUID = 1998010439847123984L;
    private final String authority;
    private final Instant issuedAt;

    private FactorGrantedAuthority(String authority, Instant issuedAt) {
        Assert.notNull((Object)authority, (String)"authority cannot be null");
        Assert.notNull((Object)issuedAt, (String)"issuedAt cannot be null");
        this.authority = authority;
        this.issuedAt = issuedAt;
    }

    public static Builder withAuthority(String authority) {
        return new Builder(authority);
    }

    public static Builder withFactor(String factor) {
        Assert.hasText((String)factor, (String)"factor cannot be empty");
        Assert.isTrue((!factor.startsWith("FACTOR_") ? 1 : 0) != 0, () -> "factor cannot start with 'FACTOR_' got '" + factor + "'");
        return FactorGrantedAuthority.withAuthority("FACTOR_" + factor);
    }

    public static FactorGrantedAuthority fromAuthority(String authority) {
        return FactorGrantedAuthority.withAuthority(authority).build();
    }

    public static FactorGrantedAuthority fromFactor(String factor) {
        return FactorGrantedAuthority.withFactor(factor).build();
    }

    @Override
    public String getAuthority() {
        return this.authority;
    }

    public Instant getIssuedAt() {
        return this.issuedAt;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof FactorGrantedAuthority) {
            FactorGrantedAuthority fga = (FactorGrantedAuthority)obj;
            return this.authority.equals(fga.authority) && this.issuedAt.equals(fga.issuedAt);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.authority, this.issuedAt);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("FactorGrantedAuthority [");
        sb.append("authority=").append(this.authority);
        sb.append(", issuedAt=").append(this.issuedAt);
        sb.append("]");
        return sb.toString();
    }

    public static final class Builder {
        private final String authority;
        private @Nullable Instant issuedAt;

        private Builder(String authority) {
            Assert.hasText((String)authority, (String)"A granted authority textual representation is required");
            this.authority = authority;
        }

        public Builder issuedAt(Instant issuedAt) {
            Assert.notNull((Object)issuedAt, (String)"issuedAt cannot be null");
            this.issuedAt = issuedAt;
            return this;
        }

        public FactorGrantedAuthority build() {
            if (this.issuedAt == null) {
                this.issuedAt = Instant.now();
            }
            return new FactorGrantedAuthority(this.authority, this.issuedAt);
        }
    }
}

