/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.benchmark.jmh;

import java.util.Arrays;
import java.util.Random;
import java.util.SplittableRandom;
import java.util.concurrent.TimeUnit;
import java.util.function.IntSupplier;
import org.apache.lucene.util.ArrayUtil;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Level;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Warmup;

@BenchmarkMode(value={Mode.Throughput})
@OutputTimeUnit(value=TimeUnit.MICROSECONDS)
@State(value=Scope.Benchmark)
@Warmup(iterations=3, time=1)
@Measurement(iterations=5, time=1)
@Fork(value=1, jvmArgsAppend={"-Xmx1g", "-Xms1g", "-XX:+AlwaysPreTouch"})
public class BitsetToArrayBenchmark {
    private final SplittableRandom R = new SplittableRandom(4314123142L);
    @Param(value={"5", "10", "20", "30", "40", "50", "60"})
    int bitCount;
    private long word;
    private int[] resultArray;
    private int base;
    private int offset;

    @Setup(value=Level.Trial)
    public void setup() {
        this.base = this.R.nextInt(1000);
        this.resultArray = new int[this.bitCount + 64 + 64];
    }

    @Setup(value=Level.Invocation)
    public void setupInvocation() {
        this.word = 0L;
        while (Long.bitCount(this.word) < this.bitCount) {
            this.word |= 1L << this.R.nextInt(64);
        }
        this.offset = this.R.nextInt(64);
    }

    @Benchmark
    public int whileLoop() {
        return BitsetToArrayBenchmark._whileLoop(this.word, this.resultArray, this.offset, this.base);
    }

    @Benchmark
    public int forLoop() {
        return BitsetToArrayBenchmark._forLoop(this.word, this.resultArray, this.offset, this.base);
    }

    @Benchmark
    public int forLoopManualUnrolling() {
        return BitsetToArrayBenchmark._forLoopManualUnrolling(this.word, this.resultArray, this.offset, this.base);
    }

    @Benchmark
    public int dense() {
        return BitsetToArrayBenchmark._dense(this.word, this.resultArray, this.offset, this.base);
    }

    @Benchmark
    public int denseBranchLess() {
        return BitsetToArrayBenchmark._denseBranchLess(this.word, this.resultArray, this.offset, this.base);
    }

    @Benchmark
    public int denseBranchLessUnrolling() {
        return BitsetToArrayBenchmark._denseBranchLessUnrolling(this.word, this.resultArray, this.offset, this.base);
    }

    @Benchmark
    public int denseBranchLessParallel() {
        return BitsetToArrayBenchmark._denseBranchLessParallel(this.word, this.resultArray, this.offset, this.base);
    }

    @Benchmark
    public int denseBranchLessCmov() {
        return BitsetToArrayBenchmark._denseBranchLessCmov(this.word, this.resultArray, this.offset, this.base);
    }

    @Benchmark
    public int denseInvert() {
        return BitsetToArrayBenchmark._denseInvert(this.word, this.resultArray, this.offset, this.base);
    }

    @Benchmark
    public int hybrid() {
        return BitsetToArrayBenchmark._hybrid(this.word, this.resultArray, this.offset, this.base);
    }

    private static int _whileLoop(long word, int[] resultArray, int offset, int base) {
        while (word != 0L) {
            int bit = Long.numberOfTrailingZeros(word);
            resultArray[offset++] = base + bit;
            word ^= 1L << bit;
        }
        return offset;
    }

    private static int _forLoop(long word, int[] resultArray, int offset, int base) {
        int to = offset + Long.bitCount(word);
        for (int i = offset; i < to; ++i) {
            int bit = Long.numberOfTrailingZeros(word);
            resultArray[i] = base + bit;
            word ^= 1L << bit;
        }
        return to;
    }

    private static int _forLoopManualUnrolling(long word, int[] resultArray, int offset, int base) {
        int ntz;
        int i;
        int to = offset + Long.bitCount(word);
        for (i = offset; i < to - 3; i += 4) {
            ntz = Long.numberOfTrailingZeros(word);
            resultArray[i] = base + ntz;
            word ^= 1L << ntz;
            ntz = Long.numberOfTrailingZeros(word);
            resultArray[i + 1] = base + ntz;
            word ^= 1L << ntz;
            ntz = Long.numberOfTrailingZeros(word);
            resultArray[i + 2] = base + ntz;
            word ^= 1L << ntz;
            ntz = Long.numberOfTrailingZeros(word);
            resultArray[i + 3] = base + ntz;
            word ^= 1L << ntz;
        }
        while (i < to) {
            ntz = Long.numberOfTrailingZeros(word);
            resultArray[i] = base + ntz;
            word ^= 1L << ntz;
            ++i;
        }
        return to;
    }

    private static int _dense(long word, int[] resultArray, int offset, int base) {
        for (int i = 0; i < 64; ++i) {
            if ((word & 1L << i) == 0L) continue;
            resultArray[offset++] = base + i;
        }
        return offset;
    }

    private static int _denseBranchLess(long word, int[] resultArray, int offset, int base) {
        int i;
        int lWord = (int)word;
        int hWord = (int)(word >>> 32);
        for (i = 0; i < 32; ++i) {
            resultArray[offset] = base + i;
            offset += lWord & 1;
            lWord >>>= 1;
        }
        for (i = 32; i < 64; ++i) {
            resultArray[offset] = base + i;
            offset += hWord & 1;
            hWord >>>= 1;
        }
        return offset;
    }

    private static int _denseBranchLessCmov(long word, int[] resultArray, int offset, int base) {
        for (int j = 0; j < 64; ++j) {
            resultArray[offset] = base + j;
            long bit = word & 1L << j;
            if (bit == 0L) continue;
            ++offset;
        }
        return offset;
    }

    private static int _denseBranchLessUnrolling(long word, int[] resultArray, int offset, int base) {
        int lWord = (int)word;
        int hWord = (int)(word >>> 32);
        resultArray[offset] = base + 0;
        resultArray[offset += lWord >>> 0 & 1] = base + 1;
        resultArray[offset += lWord >>> 1 & 1] = base + 2;
        resultArray[offset += lWord >>> 2 & 1] = base + 3;
        resultArray[offset += lWord >>> 3 & 1] = base + 4;
        resultArray[offset += lWord >>> 4 & 1] = base + 5;
        resultArray[offset += lWord >>> 5 & 1] = base + 6;
        resultArray[offset += lWord >>> 6 & 1] = base + 7;
        resultArray[offset += lWord >>> 7 & 1] = base + 8;
        resultArray[offset += lWord >>> 8 & 1] = base + 9;
        resultArray[offset += lWord >>> 9 & 1] = base + 10;
        resultArray[offset += lWord >>> 10 & 1] = base + 11;
        resultArray[offset += lWord >>> 11 & 1] = base + 12;
        resultArray[offset += lWord >>> 12 & 1] = base + 13;
        resultArray[offset += lWord >>> 13 & 1] = base + 14;
        resultArray[offset += lWord >>> 14 & 1] = base + 15;
        resultArray[offset += lWord >>> 15 & 1] = base + 16;
        resultArray[offset += lWord >>> 16 & 1] = base + 17;
        resultArray[offset += lWord >>> 17 & 1] = base + 18;
        resultArray[offset += lWord >>> 18 & 1] = base + 19;
        resultArray[offset += lWord >>> 19 & 1] = base + 20;
        resultArray[offset += lWord >>> 20 & 1] = base + 21;
        resultArray[offset += lWord >>> 21 & 1] = base + 22;
        resultArray[offset += lWord >>> 22 & 1] = base + 23;
        resultArray[offset += lWord >>> 23 & 1] = base + 24;
        resultArray[offset += lWord >>> 24 & 1] = base + 25;
        resultArray[offset += lWord >>> 25 & 1] = base + 26;
        resultArray[offset += lWord >>> 26 & 1] = base + 27;
        resultArray[offset += lWord >>> 27 & 1] = base + 28;
        resultArray[offset += lWord >>> 28 & 1] = base + 29;
        resultArray[offset += lWord >>> 29 & 1] = base + 30;
        resultArray[offset += lWord >>> 30 & 1] = base + 31;
        resultArray[offset += lWord >>> 31 & 1] = base + 32;
        resultArray[offset += hWord >>> 0 & 1] = base + 33;
        resultArray[offset += hWord >>> 1 & 1] = base + 34;
        resultArray[offset += hWord >>> 2 & 1] = base + 35;
        resultArray[offset += hWord >>> 3 & 1] = base + 36;
        resultArray[offset += hWord >>> 4 & 1] = base + 37;
        resultArray[offset += hWord >>> 5 & 1] = base + 38;
        resultArray[offset += hWord >>> 6 & 1] = base + 39;
        resultArray[offset += hWord >>> 7 & 1] = base + 40;
        resultArray[offset += hWord >>> 8 & 1] = base + 41;
        resultArray[offset += hWord >>> 9 & 1] = base + 42;
        resultArray[offset += hWord >>> 10 & 1] = base + 43;
        resultArray[offset += hWord >>> 11 & 1] = base + 44;
        resultArray[offset += hWord >>> 12 & 1] = base + 45;
        resultArray[offset += hWord >>> 13 & 1] = base + 46;
        resultArray[offset += hWord >>> 14 & 1] = base + 47;
        resultArray[offset += hWord >>> 15 & 1] = base + 48;
        resultArray[offset += hWord >>> 16 & 1] = base + 49;
        resultArray[offset += hWord >>> 17 & 1] = base + 50;
        resultArray[offset += hWord >>> 18 & 1] = base + 51;
        resultArray[offset += hWord >>> 19 & 1] = base + 52;
        resultArray[offset += hWord >>> 20 & 1] = base + 53;
        resultArray[offset += hWord >>> 21 & 1] = base + 54;
        resultArray[offset += hWord >>> 22 & 1] = base + 55;
        resultArray[offset += hWord >>> 23 & 1] = base + 56;
        resultArray[offset += hWord >>> 24 & 1] = base + 57;
        resultArray[offset += hWord >>> 25 & 1] = base + 58;
        resultArray[offset += hWord >>> 26 & 1] = base + 59;
        resultArray[offset += hWord >>> 27 & 1] = base + 60;
        resultArray[offset += hWord >>> 28 & 1] = base + 61;
        resultArray[offset += hWord >>> 29 & 1] = base + 62;
        resultArray[offset += hWord >>> 30 & 1] = base + 63;
        return offset += hWord >>> 31 & 1;
    }

    private static int _denseBranchLessParallel(long word, int[] resultArray, int offset, int base) {
        int offset32;
        int lWord = (int)word;
        int hWord = (int)(word >>> 32);
        int hOffset = offset32 = offset + Integer.bitCount(lWord);
        for (int i = 0; i < 32; ++i) {
            resultArray[offset] = base + i;
            resultArray[hOffset] = base + i + 32;
            offset += lWord >>> i & 1;
            hOffset += hWord >>> i & 1;
        }
        resultArray[offset32] = base + 32 + Integer.numberOfTrailingZeros(hWord);
        return hOffset;
    }

    private static int _denseInvert(long word, int[] resultArray, int offset, int base) {
        int bit = 0;
        while (word != 0L) {
            int zeros = Long.numberOfTrailingZeros(word);
            bit += zeros;
            int ones = Long.numberOfTrailingZeros((word >>>= zeros) ^ 0xFFFFFFFFFFFFFFFFL);
            word >>>= ones;
            for (int i = 0; i < ones; ++i) {
                resultArray[offset++] = i + bit;
            }
            bit += ones;
        }
        return offset;
    }

    private static int _hybrid(long word, int[] resultArray, int offset, int base) {
        int bitCount = Long.bitCount(word);
        if (bitCount >= 32) {
            return BitsetToArrayBenchmark._denseBranchLessParallel(word, resultArray, offset, base);
        }
        int to = offset + Long.bitCount(word);
        for (int i = offset; i < to; ++i) {
            int ntz = Long.numberOfTrailingZeros(word);
            resultArray[i] = base + ntz;
            word ^= 1L << ntz;
        }
        return to;
    }

    public static void main(String[] args) {
        Random r = new Random(System.currentTimeMillis());
        long word = r.nextLong();
        int[] expected = new int[128];
        int expectedSize = BitsetToArrayBenchmark._whileLoop(word, expected, 0, 0);
        int[] actual = new int[128];
        for (IntSupplier supplier : new IntSupplier[]{() -> BitsetToArrayBenchmark._whileLoop(word, actual, 0, 0), () -> BitsetToArrayBenchmark._forLoop(word, actual, 0, 0), () -> BitsetToArrayBenchmark._forLoopManualUnrolling(word, actual, 0, 0), () -> BitsetToArrayBenchmark._dense(word, actual, 0, 0), () -> BitsetToArrayBenchmark._denseBranchLess(word, actual, 0, 0), () -> BitsetToArrayBenchmark._denseBranchLessUnrolling(word, actual, 0, 0), () -> BitsetToArrayBenchmark._denseBranchLessParallel(word, actual, 0, 0), () -> BitsetToArrayBenchmark._denseBranchLessCmov(word, actual, 0, 0), () -> BitsetToArrayBenchmark._denseInvert(word, actual, 0, 0), () -> BitsetToArrayBenchmark._hybrid(word, actual, 0, 0)}) {
            int actualSize = supplier.getAsInt();
            if (actualSize != expectedSize) {
                throw new AssertionError((Object)("Expected size: " + expectedSize + ", but got: " + actualSize));
            }
            if (!Arrays.equals(expected, 0, expectedSize, actual, 0, actualSize)) {
                throw new AssertionError((Object)("Arrays do not match for supplier: " + String.valueOf(supplier) + ", expected: " + Arrays.toString(ArrayUtil.copyOfSubArray((int[])expected, (int)0, (int)expectedSize)) + ", but got: " + Arrays.toString(ArrayUtil.copyOfSubArray((int[])actual, (int)0, (int)actualSize))));
            }
        }
    }
}

