/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.function.ToLongFunction;
import org.apache.lucene.index.BaseCompositeReader;
import org.apache.lucene.index.DocValuesSkipper;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.PointValues;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.SortedNumericSortField;
import org.apache.lucene.util.NumericUtils;

public abstract class SegmentOrder {
    public abstract IndexReader reorder(IndexReader var1) throws IOException;

    public static SegmentOrder fromSort(Sort sort) {
        SortField primarySort = sort.getSort()[0];
        Object missingValue = primarySort.getMissingValue();
        SortField.Type type = primarySort.getType();
        if (primarySort instanceof SortedNumericSortField) {
            SortedNumericSortField snsf = (SortedNumericSortField)primarySort;
            type = snsf.getNumericType();
        }
        return switch (type) {
            case SortField.Type.INT -> SegmentOrder.numericSorter(primarySort.getField(), missingValue == null ? null : Long.valueOf(((Integer)missingValue).longValue()), primarySort.getReverse(), b -> NumericUtils.sortableBytesToInt(b, 0));
            case SortField.Type.LONG -> SegmentOrder.numericSorter(primarySort.getField(), missingValue == null ? null : (Long)missingValue, primarySort.getReverse(), b -> NumericUtils.sortableBytesToLong(b, 0));
            case SortField.Type.FLOAT -> SegmentOrder.numericSorter(primarySort.getField(), missingValue == null ? null : Long.valueOf(NumericUtils.floatToSortableInt(((Float)missingValue).floatValue())), primarySort.getReverse(), b -> NumericUtils.sortableBytesToInt(b, 0));
            case SortField.Type.DOUBLE -> SegmentOrder.numericSorter(primarySort.getField(), missingValue == null ? null : Long.valueOf(NumericUtils.doubleToSortableLong((Double)missingValue)), primarySort.getReverse(), b -> NumericUtils.sortableBytesToLong(b, 0));
            default -> new SegmentOrder(){

                @Override
                public IndexReader reorder(IndexReader reader) {
                    return reader;
                }
            };
        };
    }

    private static SegmentOrder numericSorter(String field, Long missingValue, boolean reverse, ToLongFunction<byte[]> pointDecoder) {
        final NumericFieldReaderContextComparator comparator = new NumericFieldReaderContextComparator(field, missingValue, reverse, pointDecoder);
        return new SegmentOrder(){

            @Override
            public IndexReader reorder(final IndexReader reader) throws IOException {
                return new BaseCompositeReader<LeafReader>(this, (LeafReader[])reader.leaves().stream().map(LeafReaderContext::reader).toArray(LeafReader[]::new), (Comparator)comparator){

                    @Override
                    protected void doClose() {
                    }

                    @Override
                    public IndexReader.CacheHelper getReaderCacheHelper() {
                        return reader.getReaderCacheHelper();
                    }
                };
            }
        };
    }

    private static class NumericFieldReaderContextComparator
    implements Comparator<LeafReader> {
        private final Map<Object, Long> cachedSortValues = new HashMap<Object, Long>();
        private final String field;
        private final boolean reverse;
        private final Long missingValue;
        private final ToLongFunction<byte[]> pointDecoder;

        NumericFieldReaderContextComparator(String field, Long missingValue, boolean reverse, ToLongFunction<byte[]> pointDecoder) {
            this.field = field;
            this.missingValue = missingValue;
            this.reverse = reverse;
            this.pointDecoder = pointDecoder;
        }

        @Override
        public int compare(LeafReader o1, LeafReader o2) {
            return this.reverse ? Long.compare(this.getSortValue(o2), this.getSortValue(o1)) : Long.compare(this.getSortValue(o1), this.getSortValue(o2));
        }

        private long getSortValue(LeafReader reader) {
            IndexReader.CacheKey key = reader.getCoreCacheHelper().getKey();
            if (!this.cachedSortValues.containsKey(key)) {
                this.cachedSortValues.put(key, this.loadSortValue(reader));
            }
            return this.cachedSortValues.get(key);
        }

        private long loadSortValue(LeafReader reader) {
            try {
                DocValuesSkipper skipper = reader.getDocValuesSkipper(this.field);
                if (skipper != null) {
                    if (skipper.docCount() == reader.maxDoc() || this.missingValue == null) {
                        return this.reverse ? skipper.maxValue() : skipper.minValue();
                    }
                    if (this.reverse) {
                        return Math.max(skipper.maxValue(), this.missingValue);
                    }
                    return Math.min(skipper.minValue(), this.missingValue);
                }
                PointValues pointValues = reader.getPointValues(this.field);
                if (pointValues != null) {
                    if (pointValues.getDocCount() == reader.maxDoc() || this.missingValue == null) {
                        if (this.reverse) {
                            return this.pointDecoder.applyAsLong(pointValues.getMaxPackedValue());
                        }
                        return this.pointDecoder.applyAsLong(pointValues.getMinPackedValue());
                    }
                    if (this.reverse) {
                        return Math.max(this.pointDecoder.applyAsLong(pointValues.getMaxPackedValue()), this.missingValue);
                    }
                    return Math.min(this.pointDecoder.applyAsLong(pointValues.getMinPackedValue()), this.missingValue);
                }
            }
            catch (IOException e) {
                return this.reverse ? Long.MAX_VALUE : Long.MIN_VALUE;
            }
            return this.reverse ? Long.MAX_VALUE : Long.MIN_VALUE;
        }
    }
}

