/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.sandbox.search;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import org.apache.lucene.sandbox.search.AggregatedQueryLeafProfilerResult;
import org.apache.lucene.sandbox.search.QueryProfilerTimer;
import org.apache.lucene.sandbox.search.QueryProfilerTimingType;

public class QueryLeafProfilerBreakdown {
    private static final Collection<QueryProfilerTimingType> LEAF_LEVEL_TIMING_TYPE = Arrays.stream(QueryProfilerTimingType.values()).filter(t -> t.isLeafLevel()).toList();
    private final QueryProfilerTimer[] timers = new QueryProfilerTimer[LEAF_LEVEL_TIMING_TYPE.size()];
    EnumMap<QueryProfilerTimingType, QueryProfilerTimer> map;

    public QueryLeafProfilerBreakdown() {
        for (int i = 0; i < this.timers.length; ++i) {
            this.timers[i] = new QueryProfilerTimer();
        }
    }

    public QueryProfilerTimer getTimer(QueryProfilerTimingType type) {
        return this.timers[type.ordinal()];
    }

    public final Map<String, Long> toBreakdownMap() {
        HashMap<Object, Long> map = HashMap.newHashMap(this.timers.length * 2);
        for (QueryProfilerTimingType type : LEAF_LEVEL_TIMING_TYPE) {
            map.put(type.toString(), this.timers[type.ordinal()].getApproximateTiming());
            map.put(type.toString() + "_count", this.timers[type.ordinal()].getCount());
        }
        return Collections.unmodifiableMap(map);
    }

    public final AggregatedQueryLeafProfilerResult getLeafProfilerResult(Thread thread) {
        HashMap<String, Long> map = HashMap.newHashMap(LEAF_LEVEL_TIMING_TYPE.size() * 2);
        long sliceStartTime = Long.MAX_VALUE;
        long sliceEndTime = Long.MIN_VALUE;
        for (QueryProfilerTimingType type : LEAF_LEVEL_TIMING_TYPE) {
            QueryProfilerTimer timer = this.timers[type.ordinal()];
            if (timer.getCount() > 0L) {
                sliceStartTime = Math.min(sliceStartTime, timer.getEarliestTimerStartTime());
                sliceEndTime = Math.max(sliceEndTime, timer.getEarliestTimerStartTime() + timer.getApproximateTiming());
            }
            map.put(type.toString(), timer.getApproximateTiming());
            map.put(type.toString() + "_count", timer.getCount());
        }
        return new AggregatedQueryLeafProfilerResult(thread, map, sliceStartTime, sliceEndTime - sliceStartTime);
    }

    public final long toTotalTime() {
        long total = 0L;
        for (QueryProfilerTimer timer : this.timers) {
            total += timer.getApproximateTiming();
        }
        return total;
    }
}

