/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.server;

import java.io.Serializable;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.kyuubi.Logging;
import org.apache.kyuubi.Utils$;
import org.apache.kyuubi.config.ConfigEntry;
import org.apache.kyuubi.config.KyuubiConf;
import org.apache.kyuubi.config.KyuubiConf$;
import org.apache.kyuubi.ha.HighAvailabilityConf$;
import org.apache.kyuubi.ha.client.AuthTypes$;
import org.apache.kyuubi.ha.client.ServiceDiscovery$;
import org.apache.kyuubi.package$;
import org.apache.kyuubi.server.KyuubiServer;
import org.apache.kyuubi.service.ServiceState$;
import org.apache.kyuubi.session.KyuubiSessionManager;
import org.apache.kyuubi.util.KyuubiHadoopUtils$;
import org.apache.kyuubi.util.SignalRegister$;
import org.apache.kyuubi.zookeeper.EmbeddedZookeeper;
import org.slf4j.Logger;
import scala.Array$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.util.Properties$;

public final class KyuubiServer$
implements Logging {
    public static KyuubiServer$ MODULE$;
    private KyuubiServer kyuubiServer;
    private volatile Configuration hadoopConf;
    private String[] commandArgs;
    private transient Logger org$apache$kyuubi$Logging$$log_;

    static {
        new KyuubiServer$();
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public void debug(Function0<Object> message) {
        Logging.debug$((Logging)this, message);
    }

    public void debug(Function0<Object> message, Throwable t) {
        Logging.debug$((Logging)this, message, (Throwable)t);
    }

    public void info(Function0<Object> message) {
        Logging.info$((Logging)this, message);
    }

    public void info(Function0<Object> message, Throwable t) {
        Logging.info$((Logging)this, message, (Throwable)t);
    }

    public void warn(Function0<Object> message) {
        Logging.warn$((Logging)this, message);
    }

    public void warn(Function0<Object> message, Throwable t) {
        Logging.warn$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<Object> message, Throwable t) {
        Logging.error$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<Object> message) {
        Logging.error$((Logging)this, message);
    }

    public void initializeLoggerIfNecessary(boolean isInterpreter) {
        Logging.initializeLoggerIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public Logger org$apache$kyuubi$Logging$$log_() {
        return this.org$apache$kyuubi$Logging$$log_;
    }

    public void org$apache$kyuubi$Logging$$log__$eq(Logger x$1) {
        this.org$apache$kyuubi$Logging$$log_ = x$1;
    }

    public KyuubiServer kyuubiServer() {
        return this.kyuubiServer;
    }

    public void kyuubiServer_$eq(KyuubiServer x$1) {
        this.kyuubiServer = x$1;
    }

    public Configuration hadoopConf() {
        return this.hadoopConf;
    }

    public void hadoopConf_$eq(Configuration x$1) {
        this.hadoopConf = x$1;
    }

    private String[] commandArgs() {
        return this.commandArgs;
    }

    private void commandArgs_$eq(String[] x$1) {
        this.commandArgs = x$1;
    }

    public KyuubiServer startServer(KyuubiConf conf) {
        KyuubiServer kyuubiServer;
        Option option;
        this.hadoopConf_$eq(KyuubiHadoopUtils$.MODULE$.newHadoopConf(conf, KyuubiHadoopUtils$.MODULE$.newHadoopConf$default$2()));
        None$ embeddedZkServer = None$.MODULE$;
        if (!ServiceDiscovery$.MODULE$.supportServiceDiscovery(conf)) {
            embeddedZkServer = new Some((Object)new EmbeddedZookeeper());
            embeddedZkServer.foreach((Function1 & Serializable & scala.Serializable)zkServer -> {
                zkServer.initialize(conf);
                zkServer.start();
                conf.set(HighAvailabilityConf$.MODULE$.HA_ADDRESSES(), (Object)zkServer.getConnectString());
                return conf.set(HighAvailabilityConf$.MODULE$.HA_ZK_AUTH_TYPE(), (Object)AuthTypes$.MODULE$.NONE().toString());
            });
        }
        if ((option = (Option)conf.get((ConfigEntry)KyuubiConf$.MODULE$.SERVER_NAME())) instanceof Some) {
            Some some = (Some)option;
            String s = (String)some.value();
            kyuubiServer = new KyuubiServer(s);
        } else {
            kyuubiServer = new KyuubiServer();
        }
        KyuubiServer server = kyuubiServer;
        try {
            server.initialize(conf);
        }
        catch (Exception e) {
            embeddedZkServer.filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)KyuubiServer$.$anonfun$startServer$2(x$1))).foreach((Function1 & Serializable & scala.Serializable)x$2 -> {
                x$2.stop();
                return BoxedUnit.UNIT;
            });
            throw e;
        }
        server.start();
        Utils$.MODULE$.addShutdownHook(() -> server.stop(), Utils$.MODULE$.SERVER_SHUTDOWN_PRIORITY());
        return server;
    }

    public void main(String[] args) {
        this.info((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("\n        |                  Welcome to\n        |  __  __                           __\n        | /\\ \\/\\ \\                         /\\ \\      __\n        | \\ \\ \\/'/'  __  __  __  __  __  __\\ \\ \\____/\\_\\\n        |  \\ \\ , <  /\\ \\/\\ \\/\\ \\/\\ \\/\\ \\/\\ \\\\ \\ '__`\\/\\ \\\n        |   \\ \\ \\\\`\\\\ \\ \\_\\ \\ \\ \\_\\ \\ \\ \\_\\ \\\\ \\ \\L\\ \\ \\ \\\n        |    \\ \\_\\ \\_\\/`____ \\ \\____/\\ \\____/ \\ \\_,__/\\ \\_\\\n        |     \\/_/\\/_/`/___/> \\/___/  \\/___/   \\/___/  \\/_/\n        |                /\\___/\n        |                \\/__/\n       ")).stripMargin());
        this.info((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(96).append("Version: ").append(package$.MODULE$.KYUUBI_VERSION()).append(", Revision: ").append(package$.MODULE$.REVISION()).append(" (").append(package$.MODULE$.REVISION_TIME()).append("), Branch: ").append(package$.MODULE$.BRANCH()).append(",").append(" Java: ").append(package$.MODULE$.JAVA_COMPILE_VERSION()).append(", Scala: ").append(package$.MODULE$.SCALA_COMPILE_VERSION()).append(",").append(" Spark: ").append(package$.MODULE$.SPARK_COMPILE_VERSION()).append(", Hadoop: ").append(package$.MODULE$.HADOOP_COMPILE_VERSION()).append(",").append(" Hive: ").append(package$.MODULE$.HIVE_COMPILE_VERSION()).append(", Flink: ").append(package$.MODULE$.FLINK_COMPILE_VERSION()).append(",").append(" Trino: ").append(package$.MODULE$.TRINO_COMPILE_VERSION()).toString());
        this.info((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(16).append("Using Scala ").append(Properties$.MODULE$.versionString()).append(", ").append(Properties$.MODULE$.javaVmName()).append(",").append(" ").append(Properties$.MODULE$.javaVersion()).toString());
        SignalRegister$.MODULE$.registerLogger(this.logger());
        this.commandArgs_$eq(args);
        KyuubiConf conf = this.createKyuubiConf();
        UserGroupInformation.setConfiguration((Configuration)KyuubiHadoopUtils$.MODULE$.newHadoopConf(conf, KyuubiHadoopUtils$.MODULE$.newHadoopConf$default$2()));
        this.startServer(conf);
    }

    public Configuration getHadoopConf() {
        return this.hadoopConf();
    }

    public synchronized void reloadHadoopConf() {
        Configuration _hadoopConf = KyuubiHadoopUtils$.MODULE$.newHadoopConf(this.createKyuubiConf(), KyuubiHadoopUtils$.MODULE$.newHadoopConf$default$2());
        this.hadoopConf_$eq(_hadoopConf);
    }

    public void refreshUserDefaultsConf() {
        KyuubiConf kyuubiConf = this.kyuubiServer().conf();
        synchronized (kyuubiConf) {
            Map existedUserDefaults = this.kyuubiServer().conf().getAllUserDefaults();
            Map refreshedUserDefaults = this.createKyuubiConf().getAllUserDefaults();
            this.refreshConfig("user defaults", (Map<String, String>)existedUserDefaults, (Map<String, String>)refreshedUserDefaults);
        }
    }

    public void refreshKubernetesConf() {
        KyuubiConf kyuubiConf = this.kyuubiServer().conf();
        synchronized (kyuubiConf) {
            Map existedKubernetesConf = (Map)this.kyuubiServer().conf().getAll().filter((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)KyuubiServer$.$anonfun$refreshKubernetesConf$1(x$3)));
            Map refreshedKubernetesConf = (Map)this.createKyuubiConf().getAll().filter((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)KyuubiServer$.$anonfun$refreshKubernetesConf$2(x$4)));
            this.refreshConfig("kubernetes", (Map<String, String>)existedKubernetesConf, (Map<String, String>)refreshedKubernetesConf);
            ((KyuubiSessionManager)this.kyuubiServer().backendService().sessionManager()).applicationManager().getKubernetesApplicationOperation().foreach((Function1 & Serializable & scala.Serializable)x$5 -> {
                x$5.initializeKubernetesClient(KyuubiServer$.MODULE$.kyuubiServer().conf());
                return BoxedUnit.UNIT;
            });
        }
    }

    private void refreshConfig(String configDomain, Map<String, String> existing, Map<String, String> refreshed) {
        Tuple3 tuple3 = new Tuple3((Object)BoxesRunTime.boxToInteger((int)0), (Object)BoxesRunTime.boxToInteger((int)0), (Object)BoxesRunTime.boxToInteger((int)0));
        if (tuple3 == null) {
            throw new MatchError((Object)tuple3);
        }
        int unsetCount = BoxesRunTime.unboxToInt((Object)tuple3._1());
        int updatedCount = BoxesRunTime.unboxToInt((Object)tuple3._2());
        int addedCount = BoxesRunTime.unboxToInt((Object)tuple3._3());
        Tuple3 tuple32 = new Tuple3((Object)BoxesRunTime.boxToInteger((int)unsetCount), (Object)BoxesRunTime.boxToInteger((int)updatedCount), (Object)BoxesRunTime.boxToInteger((int)addedCount));
        IntRef unsetCount2 = IntRef.create((int)BoxesRunTime.unboxToInt((Object)tuple32._1()));
        IntRef updatedCount2 = IntRef.create((int)BoxesRunTime.unboxToInt((Object)tuple32._2()));
        IntRef addedCount2 = IntRef.create((int)BoxesRunTime.unboxToInt((Object)tuple32._3()));
        existing.withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)KyuubiServer$.$anonfun$refreshConfig$1(check$ifrefutable$1))).withFilter((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)KyuubiServer$.$anonfun$refreshConfig$2(refreshed, x$7))).foreach((Function1 & Serializable & scala.Serializable)x$8 -> {
            KyuubiServer$.$anonfun$refreshConfig$3(unsetCount2, x$8);
            return BoxedUnit.UNIT;
        });
        refreshed.withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$2 -> BoxesRunTime.boxToBoolean((boolean)KyuubiServer$.$anonfun$refreshConfig$4(check$ifrefutable$2))).foreach((Function1 & Serializable & scala.Serializable)x$9 -> {
            Tuple2 tuple2 = x$9;
            if (tuple2 != null) {
                String k = (String)tuple2._1();
                String v = (String)tuple2._2();
                if (existing.contains((Object)k)) {
                    if (!StringUtils.equals((CharSequence)((CharSequence)existing.get((Object)k).orNull(Predef$.MODULE$.$conforms())), (CharSequence)v)) {
                        ++updatedCount$1.elem;
                    }
                } else {
                    ++addedCount$1.elem;
                }
                return MODULE$.kyuubiServer().conf().set(k, v);
            }
            throw new MatchError((Object)tuple2);
        });
        this.info((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(62).append("Refreshed ").append(configDomain).append(" configs with changes of ").append("unset: ").append(unsetCount$1.elem).append(", updated: ").append(updatedCount$1.elem).append(", added: ").append(addedCount$1.elem).toString());
    }

    public synchronized void refreshUnlimitedUsers() {
        KyuubiSessionManager sessionMgr = (KyuubiSessionManager)this.kyuubiServer().backendService().sessionManager();
        Set<String> existingUnlimitedUsers = sessionMgr.getUnlimitedUsers();
        sessionMgr.refreshUnlimitedUsers(this.createKyuubiConf());
        Set<String> refreshedUnlimitedUsers = sessionMgr.getUnlimitedUsers();
        this.info((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(35).append("Refreshed unlimited users from ").append(existingUnlimitedUsers).append(" to ").append(refreshedUnlimitedUsers).toString());
    }

    public synchronized void refreshDenyUsers() {
        KyuubiSessionManager sessionMgr = (KyuubiSessionManager)this.kyuubiServer().backendService().sessionManager();
        Set<String> existingDenyUsers = sessionMgr.getDenyUsers();
        sessionMgr.refreshDenyUsers(this.createKyuubiConf());
        Set<String> refreshedDenyUsers = sessionMgr.getDenyUsers();
        this.info((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(30).append("Refreshed deny users from ").append(existingDenyUsers).append(" to ").append(refreshedDenyUsers).toString());
    }

    public synchronized void refreshDenyIps() {
        KyuubiSessionManager sessionMgr = (KyuubiSessionManager)this.kyuubiServer().backendService().sessionManager();
        Set<String> existingDenyIps = sessionMgr.getDenyIps();
        sessionMgr.refreshDenyIps(this.createKyuubiConf());
        Set<String> refreshedDenyIps = sessionMgr.getDenyIps();
        this.info((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(35).append("Refreshed deny client ips from ").append(existingDenyIps).append(" to ").append(refreshedDenyIps).toString());
    }

    private KyuubiConf createKyuubiConf() {
        return new KyuubiConf(KyuubiConf$.MODULE$.apply$default$1()).loadFileDefaults().loadFromArgs(this.commandArgs());
    }

    public static final /* synthetic */ boolean $anonfun$startServer$2(EmbeddedZookeeper x$1) {
        Enumeration.Value value = x$1.getServiceState();
        Enumeration.Value value2 = ServiceState$.MODULE$.STARTED();
        return !(value != null ? !value.equals(value2) : value2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$refreshKubernetesConf$1(Tuple2 x$3) {
        return ((String)x$3._1()).startsWith("kyuubi.kubernetes");
    }

    public static final /* synthetic */ boolean $anonfun$refreshKubernetesConf$2(Tuple2 x$4) {
        return ((String)x$4._1()).startsWith("kyuubi.kubernetes");
    }

    public static final /* synthetic */ boolean $anonfun$refreshConfig$1(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        return tuple2 != null;
    }

    public static final /* synthetic */ boolean $anonfun$refreshConfig$2(Map refreshed$1, Tuple2 x$7) {
        Tuple2 tuple2 = x$7;
        if (tuple2 != null) {
            String k = (String)tuple2._1();
            return !refreshed$1.contains((Object)k);
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ void $anonfun$refreshConfig$3(IntRef unsetCount$1, Tuple2 x$8) {
        Tuple2 tuple2 = x$8;
        if (tuple2 != null) {
            String k = (String)tuple2._1();
            MODULE$.kyuubiServer().conf().unset(k);
            ++unsetCount$1.elem;
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ boolean $anonfun$refreshConfig$4(Tuple2 check$ifrefutable$2) {
        Tuple2 tuple2 = check$ifrefutable$2;
        return tuple2 != null;
    }

    private KyuubiServer$() {
        MODULE$ = this;
        Logging.$init$((Logging)this);
        this.commandArgs = (String[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(String.class));
    }
}

