/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.engine.jdbc.dialect;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.Statement;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.kyuubi.engine.jdbc.dialect.JdbcDialect;
import org.apache.kyuubi.engine.jdbc.mysql.MySQLSchemaHelper;
import org.apache.kyuubi.engine.jdbc.mysql.MySQLTRowSetGenerator;
import org.apache.kyuubi.engine.jdbc.schema.JdbcTRowSetGenerator;
import org.apache.kyuubi.engine.jdbc.schema.SchemaHelper;
import org.apache.kyuubi.session.Session;
import scala.Function1;
import scala.Predef$;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u000194A\u0001C\u0005\u0001-!)1\u0004\u0001C\u00019!)a\u0004\u0001C!?!)Q\u0007\u0001C!m!)\u0001\u000b\u0001C!#\")\u0001\r\u0001C!C\")q\r\u0001C!Q\")A\u000e\u0001C![\naQ*_*R\u0019\u0012K\u0017\r\\3di*\u0011!bC\u0001\bI&\fG.Z2u\u0015\taQ\"\u0001\u0003kI\n\u001c'B\u0001\b\u0010\u0003\u0019)gnZ5oK*\u0011\u0001#E\u0001\u0007Wf,XOY5\u000b\u0005I\u0019\u0012AB1qC\u000eDWMC\u0001\u0015\u0003\ry'oZ\u0002\u0001'\t\u0001q\u0003\u0005\u0002\u001935\t\u0011\"\u0003\u0002\u001b\u0013\tY!\n\u001a2d\t&\fG.Z2u\u0003\u0019a\u0014N\\5u}Q\tQ\u0004\u0005\u0002\u0019\u0001\u0005y1M]3bi\u0016\u001cF/\u0019;f[\u0016tG\u000fF\u0002!Q5\u0002\"!\t\u0014\u000e\u0003\tR!a\t\u0013\u0002\u0007M\fHNC\u0001&\u0003\u0011Q\u0017M^1\n\u0005\u001d\u0012#!C*uCR,W.\u001a8u\u0011\u0015I#\u00011\u0001+\u0003)\u0019wN\u001c8fGRLwN\u001c\t\u0003C-J!\u0001\f\u0012\u0003\u0015\r{gN\\3di&|g\u000eC\u0004/\u0005A\u0005\t\u0019A\u0018\u0002\u0013\u0019,Go\u00195TSj,\u0007C\u0001\u00194\u001b\u0005\t$\"\u0001\u001a\u0002\u000bM\u001c\u0017\r\\1\n\u0005Q\n$aA%oi\u0006qq-\u001a;UC\ndWm])vKJLH#B\u001cC\t\u001aC\u0005C\u0001\u001d@\u001d\tIT\b\u0005\u0002;c5\t1H\u0003\u0002=+\u00051AH]8pizJ!AP\u0019\u0002\rA\u0013X\rZ3g\u0013\t\u0001\u0015I\u0001\u0004TiJLgn\u001a\u0006\u0003}EBQaQ\u0002A\u0002]\nqaY1uC2|w\rC\u0003F\u0007\u0001\u0007q'\u0001\u0004tG\",W.\u0019\u0005\u0006\u000f\u000e\u0001\raN\u0001\ni\u0006\u0014G.\u001a(b[\u0016DQ!S\u0002A\u0002)\u000b!\u0002^1cY\u0016$\u0016\u0010]3t!\rYejN\u0007\u0002\u0019*\u0011Q\nJ\u0001\u0005kRLG.\u0003\u0002P\u0019\n!A*[:u\u0003=9W\r^\"pYVlgn])vKJLHCB\u001cS3nkf\fC\u0003T\t\u0001\u0007A+A\u0004tKN\u001c\u0018n\u001c8\u0011\u0005U;V\"\u0001,\u000b\u0005M{\u0011B\u0001-W\u0005\u001d\u0019Vm]:j_:DQA\u0017\u0003A\u0002]\n1bY1uC2|wMT1nK\")A\f\u0002a\u0001o\u0005Q1o\u00195f[\u0006t\u0015-\\3\t\u000b\u001d#\u0001\u0019A\u001c\t\u000b}#\u0001\u0019A\u001c\u0002\u0015\r|G.^7o\u001d\u0006lW-A\nhKR$&k\\<TKR<UM\\3sCR|'\u000fF\u0001c!\t\u0019W-D\u0001e\u0015\t)5\"\u0003\u0002gI\n!\"\n\u001a2d)J{woU3u\u000f\u0016tWM]1u_J\fqbZ3u'\u000eDW-\\1IK2\u0004XM\u001d\u000b\u0002SB\u00111M[\u0005\u0003W\u0012\u0014AbU2iK6\f\u0007*\u001a7qKJ\fAA\\1nKR\tq\u0007")
public class MySQLDialect
extends JdbcDialect {
    @Override
    public Statement createStatement(Connection connection, int fetchSize) {
        Statement statement = connection.createStatement(1003, 1007);
        statement.setFetchSize(Integer.MIN_VALUE);
        return statement;
    }

    @Override
    public String getTablesQuery(String catalog, String schema, String tableName, List<String> tableTypes) {
        BoxedUnit boxedUnit;
        Set tTypes = tableTypes == null || tableTypes.isEmpty() ? (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"BASE TABLE", "SYSTEM VIEW", "VIEW"})) : ((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(tableTypes).asScala()).toSet();
        scala.collection.mutable.StringBuilder query = new scala.collection.mutable.StringBuilder(new StringOps(Predef$.MODULE$.augmentString("\n         |SELECT TABLE_CATALOG, TABLE_SCHEMA, TABLE_NAME, TABLE_TYPE, ENGINE,\n         |TABLE_ROWS, AVG_ROW_LENGTH, DATA_LENGTH,\n         |CREATE_TIME, UPDATE_TIME, TABLE_COLLATION, TABLE_COMMENT\n         |FROM INFORMATION_SCHEMA.TABLES\n         |")).stripMargin());
        ArrayBuffer filters = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        Object object = StringUtils.isNotBlank((CharSequence)catalog) ? filters.$plus$eq((Object)new StringBuilder(18).append("TABLE_CATALOG").append(" = '").append(catalog).append("'").toString()) : BoxedUnit.UNIT;
        Object object2 = StringUtils.isNotBlank((CharSequence)schema) ? filters.$plus$eq((Object)new StringBuilder(20).append("TABLE_SCHEMA").append(" LIKE '").append(schema).append("'").toString()) : BoxedUnit.UNIT;
        Object object3 = StringUtils.isNotBlank((CharSequence)tableName) ? filters.$plus$eq((Object)new StringBuilder(18).append("TABLE_NAME").append(" LIKE '").append(tableName).append("'").toString()) : BoxedUnit.UNIT;
        Object object4 = tTypes.nonEmpty() ? filters.$plus$eq((Object)new StringBuilder(2).append("(").append(((TraversableOnce)tTypes.map((Function1 & Serializable & scala.Serializable)tableType -> new StringBuilder(15).append("TABLE_TYPE").append(" = '").append((String)tableType).append("'").toString(), Set$.MODULE$.canBuildFrom())).mkString(" OR ")).append(")").toString()) : BoxedUnit.UNIT;
        if (filters.nonEmpty()) {
            query.append(" WHERE ");
            boxedUnit = query.append(filters.mkString(" AND "));
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return query.toString();
    }

    @Override
    public String getColumnsQuery(Session session, String catalogName, String schemaName, String tableName, String columnName) {
        BoxedUnit boxedUnit;
        scala.collection.mutable.StringBuilder query = new scala.collection.mutable.StringBuilder(new StringOps(Predef$.MODULE$.augmentString("\n        |SELECT\n        |`TABLE_CATALOG`,`TABLE_SCHEMA`,`TABLE_NAME`, `COLUMN_NAME`,`ORDINAL_POSITION`,\n        |`COLUMN_DEFAULT`,`IS_NULLABLE`,`DATA_TYPE`,`CHARACTER_MAXIMUM_LENGTH`,\n        |`CHARACTER_OCTET_LENGTH`,`NUMERIC_PRECISION`,`NUMERIC_SCALE`,`DATETIME_PRECISION`,\n        |`CHARACTER_SET_NAME`,`COLLATION_NAME`,`COLUMN_TYPE`,`COLUMN_KEY`,`EXTRA`,`PRIVILEGES`,\n        |`COLUMN_COMMENT`,`GENERATION_EXPRESSION`\n        |FROM information_schema.columns\n        |")).stripMargin());
        ArrayBuffer filters = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        Object object = StringUtils.isNotEmpty((CharSequence)catalogName) ? filters.$plus$eq((Object)new StringBuilder(18).append("TABLE_CATALOG").append(" = '").append(catalogName).append("'").toString()) : BoxedUnit.UNIT;
        Object object2 = StringUtils.isNotEmpty((CharSequence)schemaName) ? filters.$plus$eq((Object)new StringBuilder(20).append("TABLE_SCHEMA").append(" LIKE '").append(schemaName).append("'").toString()) : BoxedUnit.UNIT;
        Object object3 = StringUtils.isNotEmpty((CharSequence)tableName) ? filters.$plus$eq((Object)new StringBuilder(18).append("TABLE_NAME").append(" LIKE '").append(tableName).append("'").toString()) : BoxedUnit.UNIT;
        Object object4 = StringUtils.isNotEmpty((CharSequence)columnName) ? filters.$plus$eq((Object)new StringBuilder(19).append("COLUMN_NAME").append(" LIKE '").append(columnName).append("'").toString()) : BoxedUnit.UNIT;
        if (filters.nonEmpty()) {
            query.append(" WHERE ");
            boxedUnit = query.append(filters.mkString(" AND "));
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return query.toString();
    }

    @Override
    public JdbcTRowSetGenerator getTRowSetGenerator() {
        return new MySQLTRowSetGenerator();
    }

    @Override
    public SchemaHelper getSchemaHelper() {
        return new MySQLSchemaHelper();
    }

    @Override
    public String name() {
        return "mysql";
    }
}

