/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.client;

import java.net.URI;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.kyuubi.client.IRestClient;
import org.apache.kyuubi.client.RestClientConf;
import org.apache.kyuubi.client.RetryableRestClient;
import org.apache.kyuubi.client.auth.AuthHeaderGenerator;
import org.apache.kyuubi.client.auth.BasicAuthHeaderGenerator;
import org.apache.kyuubi.client.auth.NoAuthHeaderGenerator;
import org.apache.kyuubi.client.auth.SpnegoAuthHeaderGenerator;

public class KyuubiRestClient
implements AutoCloseable,
Cloneable {
    private IRestClient httpClient;
    private RestClientConf conf;
    private List<String> hostUrls;
    private List<String> baseUrls;
    private ApiVersion version;
    private AuthHeaderGenerator authHeaderGenerator;

    @Override
    public void close() throws Exception {
        if (this.httpClient != null) {
            this.httpClient.close();
        }
    }

    public KyuubiRestClient clone() {
        KyuubiRestClient kyuubiRestClient = new KyuubiRestClient();
        kyuubiRestClient.version = this.version;
        kyuubiRestClient.conf = this.conf;
        kyuubiRestClient.baseUrls = this.baseUrls;
        kyuubiRestClient.httpClient = RetryableRestClient.getRestClient(this.baseUrls, this.conf);
        kyuubiRestClient.authHeaderGenerator = this.authHeaderGenerator;
        return kyuubiRestClient;
    }

    public void setHostUrls(String ... hostUrls) {
        this.setHostUrls(Arrays.asList(hostUrls));
    }

    public void setHostUrls(List<String> hostUrls) {
        if (hostUrls.isEmpty()) {
            throw new IllegalArgumentException("hostUrls cannot be blank.");
        }
        this.hostUrls = hostUrls;
        List<String> baseUrls = this.initBaseUrls(hostUrls, this.version);
        this.httpClient = RetryableRestClient.getRestClient(baseUrls, this.conf);
    }

    public List<String> getHostUrls() {
        return this.hostUrls;
    }

    private KyuubiRestClient() {
    }

    private KyuubiRestClient(Builder builder) {
        this.version = builder.version;
        this.hostUrls = builder.hostUrls;
        this.baseUrls = this.initBaseUrls(builder.hostUrls, builder.version);
        RestClientConf conf = new RestClientConf();
        conf.setConnectTimeout(builder.connectTimeout);
        conf.setSocketTimeout(builder.socketTimeout);
        conf.setMaxAttempts(builder.maxAttempts);
        conf.setAttemptWaitTime(builder.attemptWaitTime);
        this.conf = conf;
        this.httpClient = RetryableRestClient.getRestClient(this.baseUrls, conf);
        switch (builder.authHeaderMethod) {
            case BASIC: {
                this.authHeaderGenerator = new BasicAuthHeaderGenerator(builder.username, builder.password);
                break;
            }
            case SPNEGO: {
                this.authHeaderGenerator = new SpnegoAuthHeaderGenerator(builder.spnegoHost);
                break;
            }
            default: {
                this.authHeaderGenerator = builder.authHeaderGenerator == null ? new NoAuthHeaderGenerator() : builder.authHeaderGenerator;
            }
        }
    }

    private List<String> initBaseUrls(List<String> hostUrls, ApiVersion version) {
        LinkedList<String> baseUrls = new LinkedList<String>();
        for (String hostUrl : hostUrls) {
            String baseUrl = String.format("%s/%s", hostUrl.replaceAll("/$", ""), version.getApiNamespace());
            baseUrls.add(baseUrl);
        }
        return baseUrls;
    }

    public String getAuthHeader() {
        return this.authHeaderGenerator.generateAuthHeader();
    }

    public IRestClient getHttpClient() {
        return this.httpClient;
    }

    public RestClientConf getConf() {
        return this.conf;
    }

    public static Builder builder(String hostUrl) {
        return new Builder(hostUrl);
    }

    public static Builder builder(String ... hostUrls) {
        return new Builder(Arrays.asList(hostUrls));
    }

    public static Builder builder(List<String> hostUrls) {
        return new Builder(hostUrls);
    }

    public static class Builder {
        private List<String> hostUrls;
        private String spnegoHost;
        private ApiVersion version = ApiVersion.V1;
        private AuthHeaderMethod authHeaderMethod = AuthHeaderMethod.BASIC;
        private AuthHeaderGenerator authHeaderGenerator;
        private String username;
        private String password;
        private int socketTimeout = 120000;
        private int connectTimeout = 30000;
        private int maxAttempts = 3;
        private int attemptWaitTime = 3000;

        public Builder(String hostUrl) {
            if (StringUtils.isBlank((CharSequence)hostUrl)) {
                throw new IllegalArgumentException("hostUrl cannot be blank.");
            }
            this.hostUrls = new LinkedList<String>();
            this.hostUrls.add(hostUrl);
        }

        public Builder(List<String> hostUrls) {
            if (hostUrls.isEmpty()) {
                throw new IllegalArgumentException("hostUrls cannot be blank.");
            }
            this.hostUrls = hostUrls;
        }

        public Builder spnegoHost(String host) {
            this.spnegoHost = host;
            return this;
        }

        public Builder apiVersion(ApiVersion version) {
            this.version = version;
            return this;
        }

        public Builder authHeaderMethod(AuthHeaderMethod authHeaderMethod) {
            this.authHeaderMethod = authHeaderMethod;
            return this;
        }

        public Builder authHeaderGenerator(AuthHeaderGenerator authHeaderGenerator) {
            this.authHeaderGenerator = authHeaderGenerator;
            this.authHeaderMethod = AuthHeaderMethod.CUSTOM;
            return this;
        }

        public Builder username(String username) {
            this.username = username;
            return this;
        }

        public Builder password(String password) {
            this.password = password;
            return this;
        }

        public Builder socketTimeout(int socketTimeout) {
            this.socketTimeout = socketTimeout;
            return this;
        }

        public Builder connectionTimeout(int connectTimeout) {
            this.connectTimeout = connectTimeout;
            return this;
        }

        public Builder maxAttempts(int maxAttempts) {
            this.maxAttempts = maxAttempts;
            return this;
        }

        public Builder attemptWaitTime(int attemptWaitTime) {
            this.attemptWaitTime = attemptWaitTime;
            return this;
        }

        public KyuubiRestClient build() {
            if (this.authHeaderMethod == AuthHeaderMethod.SPNEGO && StringUtils.isBlank((CharSequence)this.spnegoHost)) {
                if (this.hostUrls.size() > 1) {
                    throw new IllegalArgumentException("spnegoHost is invalid.");
                }
                try {
                    this.spnegoHost = new URI(this.hostUrls.get(0)).getHost();
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("spnegoHost is invalid.", e);
                }
            }
            return new KyuubiRestClient(this);
        }
    }

    public static enum ApiVersion {
        V1;


        public String getApiNamespace() {
            return "api/" + this.name().toLowerCase();
        }
    }

    public static enum AuthHeaderMethod {
        BASIC,
        SPNEGO,
        CUSTOM;

    }
}

