/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.jdbc.hive.arrow;

import java.math.BigDecimal;
import org.apache.arrow.memory.ArrowBuf;
import org.apache.arrow.vector.BigIntVector;
import org.apache.arrow.vector.BitVector;
import org.apache.arrow.vector.DateDayVector;
import org.apache.arrow.vector.DecimalVector;
import org.apache.arrow.vector.DurationVector;
import org.apache.arrow.vector.Float4Vector;
import org.apache.arrow.vector.Float8Vector;
import org.apache.arrow.vector.IntVector;
import org.apache.arrow.vector.IntervalYearVector;
import org.apache.arrow.vector.NullVector;
import org.apache.arrow.vector.SmallIntVector;
import org.apache.arrow.vector.TimeStampMicroTZVector;
import org.apache.arrow.vector.TimeStampMicroVector;
import org.apache.arrow.vector.TinyIntVector;
import org.apache.arrow.vector.ValueVector;
import org.apache.arrow.vector.VarBinaryVector;
import org.apache.arrow.vector.VarCharVector;
import org.apache.arrow.vector.holders.NullableVarCharHolder;

public class ArrowColumnVector {
    ArrowVectorAccessor accessor;
    ArrowColumnVector[] childColumns;

    public ValueVector getValueVector() {
        return this.accessor.vector;
    }

    public boolean hasNull() {
        return this.accessor.getNullCount() > 0;
    }

    public int numNulls() {
        return this.accessor.getNullCount();
    }

    public void close() {
        if (this.childColumns != null) {
            for (int i = 0; i < this.childColumns.length; ++i) {
                this.childColumns[i].close();
                this.childColumns[i] = null;
            }
            this.childColumns = null;
        }
        this.accessor.close();
    }

    public boolean isNullAt(int rowId) {
        return this.accessor.isNullAt(rowId);
    }

    public boolean getBoolean(int rowId) {
        return this.accessor.getBoolean(rowId);
    }

    public byte getByte(int rowId) {
        return this.accessor.getByte(rowId);
    }

    public short getShort(int rowId) {
        return this.accessor.getShort(rowId);
    }

    public int getInt(int rowId) {
        return this.accessor.getInt(rowId);
    }

    public long getLong(int rowId) {
        return this.accessor.getLong(rowId);
    }

    public float getFloat(int rowId) {
        return this.accessor.getFloat(rowId);
    }

    public double getDouble(int rowId) {
        return this.accessor.getDouble(rowId);
    }

    public BigDecimal getDecimal(int rowId, int precision, int scale) {
        if (this.isNullAt(rowId)) {
            return null;
        }
        return this.accessor.getDecimal(rowId, precision, scale);
    }

    public BigDecimal getDecimal(int rowId) {
        if (this.isNullAt(rowId)) {
            return null;
        }
        return this.accessor.getDecimal(rowId);
    }

    public String getString(int rowId) {
        if (this.isNullAt(rowId)) {
            return null;
        }
        return this.accessor.getString(rowId);
    }

    public byte[] getBinary(int rowId) {
        if (this.isNullAt(rowId)) {
            return null;
        }
        return this.accessor.getBinary(rowId);
    }

    public ArrowColumnVector(ValueVector vector) {
        this.initAccessor(vector);
    }

    void initAccessor(ValueVector vector) {
        if (vector instanceof BitVector) {
            this.accessor = new BooleanAccessor((BitVector)vector);
        } else if (vector instanceof TinyIntVector) {
            this.accessor = new ByteAccessor((TinyIntVector)vector);
        } else if (vector instanceof SmallIntVector) {
            this.accessor = new ShortAccessor((SmallIntVector)vector);
        } else if (vector instanceof IntVector) {
            this.accessor = new IntAccessor((IntVector)vector);
        } else if (vector instanceof BigIntVector) {
            this.accessor = new LongAccessor((BigIntVector)vector);
        } else if (vector instanceof Float4Vector) {
            this.accessor = new FloatAccessor((Float4Vector)vector);
        } else if (vector instanceof Float8Vector) {
            this.accessor = new DoubleAccessor((Float8Vector)vector);
        } else if (vector instanceof DecimalVector) {
            this.accessor = new DecimalAccessor((DecimalVector)vector);
        } else if (vector instanceof VarCharVector) {
            this.accessor = new StringAccessor((VarCharVector)vector);
        } else if (vector instanceof VarBinaryVector) {
            this.accessor = new BinaryAccessor((VarBinaryVector)vector);
        } else if (vector instanceof DateDayVector) {
            this.accessor = new DateAccessor((DateDayVector)vector);
        } else if (vector instanceof TimeStampMicroTZVector) {
            this.accessor = new TimestampAccessor((TimeStampMicroTZVector)vector);
        } else if (vector instanceof TimeStampMicroVector) {
            this.accessor = new TimestampNTZAccessor((TimeStampMicroVector)vector);
        } else if (vector instanceof NullVector) {
            this.accessor = new NullAccessor((NullVector)vector);
        } else if (vector instanceof IntervalYearVector) {
            this.accessor = new IntervalYearAccessor((IntervalYearVector)vector);
        } else if (vector instanceof DurationVector) {
            this.accessor = new DurationAccessor((DurationVector)vector);
        } else {
            throw new UnsupportedOperationException();
        }
    }

    static class DurationAccessor
    extends ArrowVectorAccessor {
        private final DurationVector accessor;

        DurationAccessor(DurationVector vector) {
            super((ValueVector)vector);
            this.accessor = vector;
        }

        @Override
        final long getLong(int rowId) {
            return DurationVector.get((ArrowBuf)this.accessor.getDataBuffer(), (int)rowId);
        }
    }

    static class IntervalYearAccessor
    extends ArrowVectorAccessor {
        private final IntervalYearVector accessor;

        IntervalYearAccessor(IntervalYearVector vector) {
            super((ValueVector)vector);
            this.accessor = vector;
        }

        @Override
        int getInt(int rowId) {
            return this.accessor.get(rowId);
        }
    }

    static class NullAccessor
    extends ArrowVectorAccessor {
        NullAccessor(NullVector vector) {
            super((ValueVector)vector);
        }
    }

    static class TimestampNTZAccessor
    extends ArrowVectorAccessor {
        private final TimeStampMicroVector accessor;

        TimestampNTZAccessor(TimeStampMicroVector vector) {
            super((ValueVector)vector);
            this.accessor = vector;
        }

        @Override
        final long getLong(int rowId) {
            return this.accessor.get(rowId);
        }
    }

    static class TimestampAccessor
    extends ArrowVectorAccessor {
        private final TimeStampMicroTZVector accessor;

        TimestampAccessor(TimeStampMicroTZVector vector) {
            super((ValueVector)vector);
            this.accessor = vector;
        }

        @Override
        final long getLong(int rowId) {
            return this.accessor.get(rowId);
        }
    }

    static class DateAccessor
    extends ArrowVectorAccessor {
        private final DateDayVector accessor;

        DateAccessor(DateDayVector vector) {
            super((ValueVector)vector);
            this.accessor = vector;
        }

        @Override
        final int getInt(int rowId) {
            return this.accessor.get(rowId);
        }
    }

    static class BinaryAccessor
    extends ArrowVectorAccessor {
        private final VarBinaryVector accessor;

        BinaryAccessor(VarBinaryVector vector) {
            super((ValueVector)vector);
            this.accessor = vector;
        }

        @Override
        final byte[] getBinary(int rowId) {
            return this.accessor.getObject(rowId);
        }
    }

    static class StringAccessor
    extends ArrowVectorAccessor {
        private final VarCharVector accessor;
        private final NullableVarCharHolder stringResult = new NullableVarCharHolder();

        StringAccessor(VarCharVector vector) {
            super((ValueVector)vector);
            this.accessor = vector;
        }

        @Override
        final String getString(int rowId) {
            this.accessor.get(rowId, this.stringResult);
            if (this.stringResult.isSet == 0) {
                return null;
            }
            return new String(this.accessor.get(rowId));
        }
    }

    static class DecimalAccessor
    extends ArrowVectorAccessor {
        private final DecimalVector accessor;

        DecimalAccessor(DecimalVector vector) {
            super((ValueVector)vector);
            this.accessor = vector;
        }

        @Override
        final BigDecimal getDecimal(int rowId, int precision, int scale) {
            if (this.isNullAt(rowId)) {
                return null;
            }
            return this.accessor.getObject(rowId);
        }

        @Override
        final BigDecimal getDecimal(int rowId) {
            if (this.isNullAt(rowId)) {
                return null;
            }
            return this.accessor.getObject(rowId);
        }
    }

    static class DoubleAccessor
    extends ArrowVectorAccessor {
        private final Float8Vector accessor;

        DoubleAccessor(Float8Vector vector) {
            super((ValueVector)vector);
            this.accessor = vector;
        }

        @Override
        final double getDouble(int rowId) {
            return this.accessor.get(rowId);
        }
    }

    static class FloatAccessor
    extends ArrowVectorAccessor {
        private final Float4Vector accessor;

        FloatAccessor(Float4Vector vector) {
            super((ValueVector)vector);
            this.accessor = vector;
        }

        @Override
        final float getFloat(int rowId) {
            return this.accessor.get(rowId);
        }
    }

    static class LongAccessor
    extends ArrowVectorAccessor {
        private final BigIntVector accessor;

        LongAccessor(BigIntVector vector) {
            super((ValueVector)vector);
            this.accessor = vector;
        }

        @Override
        final long getLong(int rowId) {
            return this.accessor.get(rowId);
        }
    }

    static class IntAccessor
    extends ArrowVectorAccessor {
        private final IntVector accessor;

        IntAccessor(IntVector vector) {
            super((ValueVector)vector);
            this.accessor = vector;
        }

        @Override
        final int getInt(int rowId) {
            return this.accessor.get(rowId);
        }
    }

    static class ShortAccessor
    extends ArrowVectorAccessor {
        private final SmallIntVector accessor;

        ShortAccessor(SmallIntVector vector) {
            super((ValueVector)vector);
            this.accessor = vector;
        }

        @Override
        final short getShort(int rowId) {
            return this.accessor.get(rowId);
        }
    }

    static class ByteAccessor
    extends ArrowVectorAccessor {
        private final TinyIntVector accessor;

        ByteAccessor(TinyIntVector vector) {
            super((ValueVector)vector);
            this.accessor = vector;
        }

        @Override
        final byte getByte(int rowId) {
            return this.accessor.get(rowId);
        }
    }

    static class BooleanAccessor
    extends ArrowVectorAccessor {
        private final BitVector accessor;

        BooleanAccessor(BitVector vector) {
            super((ValueVector)vector);
            this.accessor = vector;
        }

        @Override
        final boolean getBoolean(int rowId) {
            return this.accessor.get(rowId) == 1;
        }
    }

    static abstract class ArrowVectorAccessor {
        final ValueVector vector;

        ArrowVectorAccessor(ValueVector vector) {
            this.vector = vector;
        }

        final boolean isNullAt(int rowId) {
            return this.vector.isNull(rowId);
        }

        final int getNullCount() {
            return this.vector.getNullCount();
        }

        final void close() {
            this.vector.close();
        }

        boolean getBoolean(int rowId) {
            throw new UnsupportedOperationException();
        }

        byte getByte(int rowId) {
            throw new UnsupportedOperationException();
        }

        short getShort(int rowId) {
            throw new UnsupportedOperationException();
        }

        int getInt(int rowId) {
            throw new UnsupportedOperationException();
        }

        long getLong(int rowId) {
            throw new UnsupportedOperationException();
        }

        float getFloat(int rowId) {
            throw new UnsupportedOperationException();
        }

        double getDouble(int rowId) {
            throw new UnsupportedOperationException();
        }

        BigDecimal getDecimal(int rowId, int precision, int scale) {
            throw new UnsupportedOperationException();
        }

        BigDecimal getDecimal(int rowId) {
            throw new UnsupportedOperationException();
        }

        String getString(int rowId) {
            throw new UnsupportedOperationException();
        }

        byte[] getBinary(int rowId) {
            throw new UnsupportedOperationException();
        }

        Object getArray(int rowId) {
            throw new UnsupportedOperationException();
        }

        Object getMap(int rowId) {
            throw new UnsupportedOperationException();
        }
    }
}

