/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.util;

import org.apache.camel.util.UnsafeUriCharactersEncoder;

public final class CamelURIParser {
    private CamelURIParser() {
    }

    public static String[] parseUri(String uri) {
        int schemeStart = 0;
        int schemeEnd = 0;
        int pathStart = 0;
        int pathEnd = 0;
        int queryStart = 0;
        int len = uri.length();
        for (int i = 0; i < len; ++i) {
            char ch = uri.charAt(i);
            if (ch > '\u0080') {
                return null;
            }
            if (!UnsafeUriCharactersEncoder.isSafeFastParser(ch)) {
                return null;
            }
            if (schemeEnd == 0) {
                if (ch != ':') continue;
                schemeEnd = i;
                pathStart = i + 1;
                continue;
            }
            if (pathEnd != 0 || ch != '?') continue;
            pathEnd = i;
            queryStart = i + 1;
        }
        if (pathStart == 0 && schemeEnd != 0) {
            pathStart = schemeEnd + 1;
        }
        if (pathStart >= len) {
            return null;
        }
        String scheme = null;
        if (schemeEnd != 0) {
            scheme = uri.substring(schemeStart, schemeEnd);
        }
        if (scheme == null) {
            return null;
        }
        int next = pathStart + 1;
        if (uri.charAt(pathStart) == '/' && next < len && uri.charAt(next) == '/') {
            pathStart += 2;
        }
        String path = pathEnd != 0 ? uri.substring(pathStart, pathEnd) : uri.substring(pathStart);
        String query = null;
        if (queryStart != 0 && queryStart < len) {
            query = uri.substring(queryStart);
        }
        return new String[]{scheme, path, query};
    }
}

