/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals.foreignkeyjoin;

import java.util.Arrays;
import java.util.Objects;
import org.apache.kafka.common.errors.UnsupportedVersionException;

public class SubscriptionResponseWrapper<FV> {
    static final byte CURRENT_VERSION = 0;
    private final long[] originalValueHash;
    private final FV foreignValue;
    private final byte version;
    private final Integer primaryPartition;

    public SubscriptionResponseWrapper(long[] originalValueHash, FV foreignValue, Integer primaryPartition) {
        this(originalValueHash, foreignValue, 0, primaryPartition);
    }

    public SubscriptionResponseWrapper(long[] originalValueHash, FV foreignValue, byte version, Integer primaryPartition) {
        if (version < 0 || version > 0) {
            throw new UnsupportedVersionException("SubscriptionWrapper does not support version " + version);
        }
        this.originalValueHash = originalValueHash;
        this.foreignValue = foreignValue;
        this.version = version;
        this.primaryPartition = primaryPartition;
    }

    public long[] getOriginalValueHash() {
        return this.originalValueHash;
    }

    public FV getForeignValue() {
        return this.foreignValue;
    }

    public byte getVersion() {
        return this.version;
    }

    public Integer getPrimaryPartition() {
        return this.primaryPartition;
    }

    public String toString() {
        return "SubscriptionResponseWrapper{version=" + this.version + ", foreignValue=" + this.foreignValue + ", originalValueHash=" + Arrays.toString(this.originalValueHash) + ", primaryPartition=" + this.primaryPartition + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SubscriptionResponseWrapper that = (SubscriptionResponseWrapper)o;
        return this.version == that.version && Arrays.equals(this.originalValueHash, that.originalValueHash) && Objects.equals(this.foreignValue, that.foreignValue) && Objects.equals(this.primaryPartition, that.primaryPartition);
    }

    public int hashCode() {
        int result = Objects.hash(this.foreignValue, this.version, this.primaryPartition);
        result = 31 * result + Arrays.hashCode(this.originalValueHash);
        return result;
    }
}

