/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.commons.io;

import java.io.IOException;
import java.io.Writer;
import org.apache.juneau.commons.utils.AssertionUtils;

public class NoCloseWriter
extends Writer {
    private final Writer w;

    public NoCloseWriter(Writer w) {
        this.w = AssertionUtils.assertArgNotNull("w", w);
    }

    @Override
    public Writer append(char c) throws IOException {
        return this.w.append(c);
    }

    @Override
    public Writer append(CharSequence csq) throws IOException {
        return this.w.append(csq);
    }

    @Override
    public Writer append(CharSequence csq, int start, int end) throws IOException {
        return this.w.append(csq, start, end);
    }

    @Override
    public void close() throws IOException {
        this.w.flush();
    }

    @Override
    public void flush() throws IOException {
        this.w.flush();
    }

    public String toString() {
        return this.w.toString();
    }

    @Override
    public void write(char[] cbuf) throws IOException {
        AssertionUtils.assertArgNotNull("cbuf", cbuf);
        this.w.write(cbuf);
    }

    @Override
    public void write(char[] cbuf, int off, int len) throws IOException {
        AssertionUtils.assertArgNotNull("cbuf", cbuf);
        this.w.write(cbuf, off, len);
    }

    @Override
    public void write(int c) throws IOException {
        this.w.write(c);
    }

    @Override
    public void write(String str) throws IOException {
        AssertionUtils.assertArgNotNull("str", str);
        this.w.write(str);
    }

    @Override
    public void write(String str, int off, int len) throws IOException {
        AssertionUtils.assertArgNotNull("str", str);
        this.w.write(str, off, len);
    }
}

