/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.commons.collections;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.juneau.commons.utils.AssertionUtils;
import org.apache.juneau.commons.utils.Utils;

public class BidiMap<K, V>
implements Map<K, V> {
    private final Map<K, V> forward;
    private final Map<V, K> reverse;

    public static <K, V> Builder<K, V> create() {
        return new Builder();
    }

    public BidiMap(Builder<K, V> builder) {
        LinkedHashMap forward = builder.map.entrySet().stream().filter(x -> Utils.nn(x.getKey()) && Utils.nn(x.getValue())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (a, b) -> b, LinkedHashMap::new));
        LinkedHashMap reverse = builder.map.entrySet().stream().filter(x -> Utils.nn(x.getKey()) && Utils.nn(x.getValue())).collect(Collectors.toMap(Map.Entry::getValue, Map.Entry::getKey, (a, b) -> b, LinkedHashMap::new));
        this.forward = builder.unmodifiable ? Collections.unmodifiableMap(forward) : forward;
        this.reverse = builder.unmodifiable ? Collections.unmodifiableMap(reverse) : reverse;
    }

    @Override
    public void clear() {
        this.forward.clear();
        this.reverse.clear();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.forward.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.reverse.containsKey(value);
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this.forward.entrySet();
    }

    @Override
    public V get(Object key) {
        return this.forward.get(key);
    }

    public K getKey(V value) {
        return this.reverse.get(value);
    }

    @Override
    public boolean isEmpty() {
        return this.forward.isEmpty();
    }

    @Override
    public Set<K> keySet() {
        return this.forward.keySet();
    }

    @Override
    public V put(K key, V value) {
        K existingKeyForValue = this.reverse.get(value);
        AssertionUtils.assertArg(!Utils.nn(existingKeyForValue) || existingKeyForValue.equals(key), "Value ''{0}'' is already mapped to key ''{1}'' in this BidiMap.", value, existingKeyForValue);
        V oldValue = this.forward.put(key, value);
        if (Utils.nn(oldValue)) {
            this.reverse.remove(oldValue);
        }
        this.reverse.put(value, key);
        return oldValue;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        for (Map.Entry<K, V> entry : m.entrySet()) {
            K key = entry.getKey();
            V value = entry.getValue();
            K existingKeyForValue = this.reverse.get(value);
            AssertionUtils.assertArg(!Utils.nn(existingKeyForValue) || existingKeyForValue.equals(key), "Value ''{0}'' is already mapped to key ''{1}'' in this BidiMap.", value, existingKeyForValue);
        }
        for (Map.Entry<K, V> entry : m.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public V remove(Object key) {
        V value = this.forward.remove(key);
        this.reverse.remove(value);
        return value;
    }

    @Override
    public int size() {
        return this.forward.size();
    }

    @Override
    public Collection<V> values() {
        return this.forward.values();
    }

    public String toString() {
        return this.forward.toString();
    }

    @Override
    public boolean equals(Object o) {
        Map o2;
        return o instanceof Map && Utils.eq(this, o2 = (Map)o, (x, y) -> x.entrySet().equals(y.entrySet()));
    }

    @Override
    public int hashCode() {
        return this.entrySet().hashCode();
    }

    public static class Builder<K, V> {
        final HashMap<K, V> map = new LinkedHashMap();
        final Set<V> values = new HashSet<V>();
        boolean unmodifiable;

        public Builder<K, V> add(K key, V value) {
            if (Utils.nn(key) && Utils.nn(value)) {
                V existingValue = this.map.get(key);
                if (Utils.nn(existingValue) && !existingValue.equals(value)) {
                    this.values.remove(existingValue);
                }
                AssertionUtils.assertArg(!this.values.contains(value) || value.equals(existingValue), "Value ''{0}'' is already mapped to a different key in this BidiMap.", value);
                this.values.add(value);
            }
            this.map.put(key, value);
            return this;
        }

        public BidiMap<K, V> build() {
            return new BidiMap(this);
        }

        public Builder<K, V> unmodifiable() {
            this.unmodifiable = true;
            return this;
        }
    }
}

