/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.bean.atom;

import java.util.Calendar;
import java.util.GregorianCalendar;
import org.apache.juneau.bean.atom.Category;
import org.apache.juneau.bean.atom.Common;
import org.apache.juneau.bean.atom.Id;
import org.apache.juneau.bean.atom.Link;
import org.apache.juneau.bean.atom.Person;
import org.apache.juneau.bean.atom.Text;
import org.apache.juneau.commons.time.GranularZonedDateTime;
import org.apache.juneau.commons.utils.StringUtils;
import org.apache.juneau.commons.utils.Utils;
import org.apache.juneau.xml.annotation.Xml;
import org.apache.juneau.xml.annotation.XmlFormat;

public class CommonEntry
extends Common {
    private Person[] authors;
    private Category[] categories;
    private Person[] contributors;
    private Id id;
    private Link[] links;
    private Text rights;
    private Text title;
    private Calendar updated;

    public CommonEntry() {
    }

    public CommonEntry(Id id, Text title, Calendar updated) {
        this.setId(id).setTitle(title).setUpdated(updated);
    }

    public CommonEntry(String id, String title, String updated) {
        this.setId(id).setTitle(title).setUpdated(updated);
    }

    @Xml(format=XmlFormat.COLLAPSED, childName="author")
    public Person[] getAuthors() {
        return this.authors;
    }

    @Xml(format=XmlFormat.COLLAPSED, childName="category")
    public Category[] getCategories() {
        return this.categories;
    }

    @Xml(format=XmlFormat.COLLAPSED, childName="contributor")
    public Person[] getContributors() {
        return this.contributors;
    }

    public Id getId() {
        return this.id;
    }

    @Xml(format=XmlFormat.COLLAPSED)
    public Link[] getLinks() {
        return this.links;
    }

    public Text getRights() {
        return this.rights;
    }

    public Text getTitle() {
        return this.title;
    }

    public Calendar getUpdated() {
        return this.updated;
    }

    public CommonEntry setAuthors(Person ... value) {
        this.authors = value;
        return this;
    }

    @Override
    public CommonEntry setBase(Object value) {
        super.setBase(value);
        return this;
    }

    public CommonEntry setCategories(Category ... value) {
        this.categories = value;
        return this;
    }

    public CommonEntry setContributors(Person ... value) {
        this.contributors = value;
        return this;
    }

    public CommonEntry setId(Id value) {
        this.id = value;
        return this;
    }

    public CommonEntry setId(String value) {
        this.setId(new Id(value));
        return this;
    }

    @Override
    public CommonEntry setLang(String value) {
        super.setLang(value);
        return this;
    }

    public CommonEntry setLinks(Link ... value) {
        this.links = value;
        return this;
    }

    public CommonEntry setRights(String value) {
        this.setRights(new Text().setText(value));
        return this;
    }

    public CommonEntry setRights(Text value) {
        this.rights = value;
        return this;
    }

    public CommonEntry setTitle(String value) {
        this.setTitle(new Text().setText(value));
        return this;
    }

    public CommonEntry setTitle(Text value) {
        this.title = value;
        return this;
    }

    public CommonEntry setUpdated(Calendar value) {
        this.updated = value;
        return this;
    }

    public CommonEntry setUpdated(String value) {
        this.setUpdated((Calendar)Utils.opt((Object)value).filter(x1 -> !StringUtils.isBlank((CharSequence)x1)).map(x -> GranularZonedDateTime.of((String)value).getZonedDateTime()).map(GregorianCalendar::from).orElse(null));
        return this;
    }
}

