/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.httppart.bean;

import java.lang.annotation.Annotation;
import java.util.List;
import org.apache.juneau.annotation.InvalidAnnotationException;
import org.apache.juneau.commons.reflect.ClassInfo;
import org.apache.juneau.commons.reflect.MethodInfo;
import org.apache.juneau.commons.reflect.ParameterInfo;
import org.apache.juneau.commons.utils.Utils;

class MethodInfoUtils {
    MethodInfoUtils() {
    }

    static void assertArgType(MethodInfo m, Class<? extends Annotation> a, Class<?> ... c) throws InvalidAnnotationException {
        List<ParameterInfo> params = m.getParameters();
        if (params.size() != 1) {
            throw new InvalidAnnotationException("Only one parameter can be passed to method with @{0} annotation.  Method=''{0}''", Utils.cns(a), m);
        }
        Class rt = params.get(0).getParameterType().inner();
        for (Class<?> cc : c) {
            if (rt != cc) continue;
            return;
        }
        throw new InvalidAnnotationException("Invalid return type for method with annotation @{0}.  Method=''{1}''", Utils.cns(a), m);
    }

    static void assertNoArgs(MethodInfo m, Class<?> a) throws InvalidAnnotationException {
        if (m.hasParameters()) {
            throw new InvalidAnnotationException("Method with @{0} annotation cannot have arguments.  Method=''{1}''", Utils.cns(a), m);
        }
    }

    static void assertReturnNotVoid(MethodInfo m, Class<?> a) throws InvalidAnnotationException {
        ClassInfo rt = m.getReturnType();
        if (rt.is(Void.TYPE)) {
            throw new InvalidAnnotationException("Invalid return type for method with annotation @{0}.  Method=''{1}''", Utils.cns(a), m);
        }
    }

    static void assertReturnType(MethodInfo m, Class<? extends Annotation> a, Class<?> ... c) throws InvalidAnnotationException {
        ClassInfo rt = m.getReturnType();
        for (Class<?> cc : c) {
            if (!rt.is(cc)) continue;
            return;
        }
        throw new InvalidAnnotationException("Invalid return type for method with annotation @{0}.  Method=''{1}''", Utils.cns(a), m);
    }
}

