/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest.util;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.juneau.commons.utils.CollectionUtils;
import org.apache.juneau.commons.utils.FileUtils;
import org.apache.juneau.commons.utils.Utils;
import org.apache.juneau.rest.util.UrlPath;
import org.apache.juneau.rest.util.UrlPathMatch;

public abstract class UrlPathMatcher
implements Comparable<UrlPathMatcher> {
    private final String pattern;

    public static UrlPathMatcher of(String pattern) {
        boolean isFilePattern = (pattern = Utils.emptyIfNull(pattern)).matches("[^\\/]+\\.[^\\/]+");
        return isFilePattern ? new FileNameMatcher(pattern) : new PathMatcher(pattern);
    }

    UrlPathMatcher(String pattern) {
        this.pattern = pattern;
    }

    @Override
    public int compareTo(UrlPathMatcher o) {
        return o.getComparator().compareTo(this.getComparator());
    }

    public String[] getVars() {
        return new String[0];
    }

    public boolean hasVars() {
        return false;
    }

    public abstract UrlPathMatch match(UrlPath var1);

    public String toString() {
        return this.pattern;
    }

    protected abstract String getComparator();

    private static class FileNameMatcher
    extends UrlPathMatcher {
        private final String basePattern;
        private final String extPattern;
        private final String comparator;

        FileNameMatcher(String pattern) {
            super(pattern);
            String base = FileUtils.getBaseName(pattern);
            String ext = FileUtils.getFileExtension(pattern);
            this.basePattern = base.equals("*") ? null : base;
            this.extPattern = ext.equals("*") ? null : ext;
            this.comparator = pattern.replaceAll("\\w+", "X").replace("*", "W");
        }

        @Override
        public String getComparator() {
            return this.comparator;
        }

        @Override
        public UrlPathMatch match(UrlPath pathInfo) {
            Optional<String> fileName = pathInfo.getFileName();
            if (fileName.isPresent()) {
                String base = FileUtils.getBaseName(fileName.get());
                String ext = FileUtils.getFileExtension(fileName.get());
                if ((this.basePattern == null || this.basePattern.equals(base)) && (this.extPattern == null || this.extPattern.equals(ext))) {
                    return new UrlPathMatch(pathInfo.getPath(), pathInfo.getParts().length, new String[0], new String[0]);
                }
            }
            return null;
        }
    }

    private static class PathMatcher
    extends UrlPathMatcher {
        private static final Pattern VAR_PATTERN = Pattern.compile("\\{([^\\}]+)\\}");
        private final String pattern;
        private final String comparator;
        private final String[] parts;
        private final String[] vars;
        private final String[] varKeys;
        private final boolean hasRemainder;

        PathMatcher(String patternString) {
            super(patternString);
            this.pattern = Utils.e(patternString) ? "/" : (patternString.charAt(0) != '/' ? "/" + patternString : patternString);
            Object c = patternString.replaceAll("\\{[^\\}]+\\}", ".").replaceAll("\\w+", "X").replaceAll("\\.", "W");
            if (((String)c).isEmpty()) {
                c = "+";
            }
            if (!((String)c).endsWith("/*")) {
                c = (String)c + "/W";
            }
            this.comparator = c;
            String[] parts = new UrlPath(this.pattern).getParts();
            this.hasRemainder = parts.length > 0 && "*".equals(parts[parts.length - 1]);
            parts = this.hasRemainder ? Arrays.copyOf(parts, parts.length - 1) : parts;
            this.parts = parts;
            this.vars = new String[parts.length];
            List<String> vars = CollectionUtils.list(new String[0]);
            for (int i = 0; i < parts.length; ++i) {
                Matcher m = VAR_PATTERN.matcher(parts[i]);
                if (!m.matches()) continue;
                this.vars[i] = m.group(1);
                vars.add(this.vars[i]);
            }
            this.varKeys = vars.isEmpty() ? null : vars.toArray(new String[vars.size()]);
        }

        @Override
        public String getComparator() {
            return this.comparator;
        }

        @Override
        public String[] getVars() {
            return this.varKeys == null ? new String[]{} : Arrays.copyOf(this.varKeys, this.varKeys.length);
        }

        @Override
        public boolean hasVars() {
            return Utils.nn(this.varKeys);
        }

        @Override
        public UrlPathMatch match(UrlPath urlPath) {
            String[] pip = urlPath.getParts();
            if (this.parts.length != pip.length) {
                if (this.hasRemainder) {
                    if (pip.length == this.parts.length - 1 && !urlPath.isTrailingSlash()) {
                        return null;
                    }
                    if (pip.length < this.parts.length) {
                        return null;
                    }
                } else if (pip.length != this.parts.length + 1 || !urlPath.isTrailingSlash()) {
                    return null;
                }
            }
            for (int i = 0; i < this.parts.length; ++i) {
                if (this.vars[i] != null || pip.length > i && ("*".equals(this.parts[i]) || pip[i].equals(this.parts[i]))) continue;
                return null;
            }
            String[] vals = this.varKeys == null ? null : new String[this.varKeys.length];
            int j = 0;
            if (Utils.nn(vals)) {
                for (int i = 0; i < this.parts.length; ++i) {
                    if (!Utils.nn(this.vars[i])) continue;
                    vals[j++] = pip[i];
                }
            }
            return new UrlPathMatch(urlPath.getPath(), this.parts.length, this.varKeys, vals);
        }
    }
}

