/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.http.header;

import java.util.function.Supplier;
import org.apache.juneau.MediaType;
import org.apache.juneau.commons.collections.Cache;
import org.apache.juneau.http.annotation.Header;
import org.apache.juneau.http.header.BasicMediaTypeHeader;

@Header(value="Content-Type")
public class ContentType
extends BasicMediaTypeHeader {
    private static final long serialVersionUID = 1L;
    private static final String NAME = "Content-Type";
    private static Cache<String, ContentType> CACHE = Cache.of(String.class, ContentType.class).build();
    public static final ContentType APPLICATION_ATOM_XML = ContentType.of("application/atom+xml");
    public static final ContentType APPLICATION_FORM_URLENCODED = ContentType.of("application/x-www-form-urlencoded");
    public static final ContentType APPLICATION_JSON = ContentType.of("application/json");
    public static final ContentType APPLICATION_OCTET_STREAM = ContentType.of("application/octet-stream");
    public static final ContentType APPLICATION_SOAP_XML = ContentType.of("application/soap+xml");
    public static final ContentType APPLICATION_SVG_XML = ContentType.of("application/svg+xml");
    public static final ContentType APPLICATION_XHTML_XML = ContentType.of("application/xhtml+xml");
    public static final ContentType APPLICATION_XML = ContentType.of("application/xml");
    public static final ContentType IMAGE_BMP = ContentType.of("image/bmp");
    public static final ContentType IMAGE_GIF = ContentType.of("image/gif");
    public static final ContentType IMAGE_JPEG = ContentType.of("image/jpeg");
    public static final ContentType IMAGE_PNG = ContentType.of("image/png");
    public static final ContentType IMAGE_SVG = ContentType.of("image/svg+xml");
    public static final ContentType IMAGE_TIFF = ContentType.of("image/tiff");
    public static final ContentType IMAGE_WEBP = ContentType.of("image/webp");
    public static final ContentType MULTIPART_FORM_DATA = ContentType.of("multipart/form-data");
    public static final ContentType TEXT_HTML = ContentType.of("text/html");
    public static final ContentType TEXT_OPENAPI = ContentType.of("text/openapi");
    public static final ContentType TEXT_PLAIN = ContentType.of("text/plain");
    public static final ContentType TEXT_XML = ContentType.of("text/xml");
    public static final ContentType WILDCARD = ContentType.of("*/*");
    public static final ContentType NULL = new ContentType((String)null);

    public static ContentType of(MediaType value) {
        return value == null ? null : new ContentType(value);
    }

    public static ContentType of(String value) {
        return value == null ? null : CACHE.get(value, () -> new ContentType(value));
    }

    public static ContentType of(Supplier<MediaType> value) {
        return value == null ? null : new ContentType(value);
    }

    public ContentType(MediaType value) {
        super(NAME, value);
    }

    public ContentType(String value) {
        super(NAME, value);
    }

    public ContentType(Supplier<MediaType> value) {
        super(NAME, value);
    }
}

