/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 *
 *   SPDX-License-Identifier: Apache-2.0
 */

package org.apache.jena.shacl.parser;

import org.apache.jena.shacl.engine.constraint.*;

public interface ConstraintVisitor {
    // SHACL Core Constraint Components
    void visit(ClassConstraint constraint);
    void visit(DatatypeConstraint constraint);
    void visit(NodeKindConstraint constraint);
    void visit(MinCount constraint);
    void visit(MaxCount constraint);
    void visit(ValueMinExclusiveConstraint constraint);
    void visit(ValueMinInclusiveConstraint constraint);
    void visit(ValueMaxInclusiveConstraint constraint);
    void visit(ValueMaxExclusiveConstraint constraint);
    void visit(StrMinLengthConstraint constraint);
    void visit(StrMaxLengthConstraint constraint);
    void visit(PatternConstraint constraint);
    void visit(StrLanguageIn constraint);
    void visit(UniqueLangConstraint constraint);
    void visit(EqualsConstraint constraint);
    void visit(DisjointConstraint constraint);
    void visit(LessThanConstraint constraint);
    void visit(LessThanOrEqualsConstraint constraint);
    void visit(ShNot constraint);
    void visit(ShAnd constraint);
    void visit(ShOr constraint);
    void visit(ShXone constraint);
    void visit(ShNode constraint);
    void visit(QualifiedValueShape constraint);
    void visit(ClosedConstraint constraint);
    void visit(HasValueConstraint constraint);
    void visit(InConstraint constraint);
    void visit(ConstraintComponentSPARQL constraint);
    void visit(SparqlConstraint constraint);

    // Other Constraints
    void visit(JViolationConstraint constraint);
    void visit(JLogConstraint constraint);
}
