/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.shacl.engine.constraint;

import java.util.Objects;
import org.apache.jena.atlas.io.IndentedWriter;
import org.apache.jena.graph.Node;
import org.apache.jena.riot.out.NodeFormatter;
import org.apache.jena.shacl.compact.writer.CompactOut;
import org.apache.jena.shacl.engine.ValidationContext;
import org.apache.jena.shacl.engine.constraint.ConstraintTerm;
import org.apache.jena.shacl.lib.ShLib;
import org.apache.jena.shacl.parser.ConstraintVisitor;
import org.apache.jena.shacl.validation.ReportItem;
import org.apache.jena.shacl.vocabulary.SHACL;
import org.apache.jena.sparql.expr.nodevalue.NodeFunctions;

public class StrMinLengthConstraint
extends ConstraintTerm {
    private final int minLength;

    public StrMinLengthConstraint(int minLength) {
        this.minLength = minLength;
    }

    public int getMinLength() {
        return this.minLength;
    }

    @Override
    public ReportItem validate(ValidationContext vCxt, Node n) {
        if (n.isBlank()) {
            String msg = this.toString() + ": Blank node: " + ShLib.displayStr(n);
            return new ReportItem(msg, n);
        }
        String str = NodeFunctions.str((Node)n);
        if (str.length() >= this.minLength) {
            return null;
        }
        String msg = this.toString() + ": String too short: " + str;
        return new ReportItem(msg, n);
    }

    @Override
    public Node getComponent() {
        return SHACL.MinLengthConstraintComponent;
    }

    @Override
    public void visit(ConstraintVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public void printCompact(IndentedWriter out, NodeFormatter nodeFmt) {
        CompactOut.compact(out, "minLength", this.minLength);
    }

    public String toString() {
        return "MinLengthConstraint[" + this.minLength + "]";
    }

    public int hashCode() {
        return Objects.hash(this.minLength);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StrMinLengthConstraint)) {
            return false;
        }
        StrMinLengthConstraint other = (StrMinLengthConstraint)obj;
        return this.minLength == other.minLength;
    }
}

